<?php

/**
 * @package     TourCodes
 * @subpackage   TourCodes
 * @Copyright(C) 2023 [Travel Portal].
 * @Version 1.0.0
 * module of the  TourCodes.
 */

namespace App\Http\Controllers\Admin;

use App\Enums\Locale;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Carbon;
use App\Models\Setting;
use App\Models\Airport;
use App\Models\TourCode;
use App\Traits\CommonService;
use DB;

class TourCodeController extends Controller
{
    use CommonService;

    /**
     * Display a listing of the markups.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $header['title']="Tour Code List";
        $header['heading']="Tour Code List";
        $queryStringConcat = '?';
        if (isset($_GET['per_page'])) {
            $queryStringConcat .= ($queryStringConcat == '') ? '?per_page=' . $_GET['per_page'] : '&per_page=' . $_GET['per_page'];
        }
        if (isset($_GET['page'])) {
            $queryStringConcat .= ($queryStringConcat == '') ? '?page=' . $_GET['page'] : '&page=' . $_GET['page'];
        }

        $appliedFilter = array(
            'per_page' => (request()->input('per_page') != NULL) ? request()->input('per_page') : Setting::where('config_key', 'general|setting|pagePerAdminRecords')->get('value')[0]['value'],
            'order_by' => (request()->input('order_by') != NULL) ? request()->input('order_by') : 'created_at',
            'sorting' => (request()->input('sorting') != NULL) ? request()->input('sorting') : 'desc',
            'origin' => (request()->input('origin') != NULL) ? request()->input('origin') : '',
            'destination' => (request()->input('destination') != NULL) ? request()->input('destination') : '',
            'status' => (request()->input('status') != NULL) ? request()->input('status') : '',
        );

        if (request()->input('origin') != NULL) {
            $appliedFilter['where'][] = ['origin', '=', request()->input('origin')];
        }

        if (request()->input('destination') != NULL) {
            $appliedFilter['where'][] = ['destination', '=', request()->input('destination')];
        }

        $tourCodeDataList = TourCode::getTourCodes($appliedFilter);
        $tourCodeDataCount = TourCode::count();

        $tourCodeData = $tourCodeDataList['data'];
        if ($tourCodeDataCount > 0) {
            //$tourCodeData->data = $tourCodeData->data->toArray();
            //echo "<pre>"; print_r($tourCodeData); die;
            foreach ($tourCodeData as $key => &$tourCode) {
                $tourCode->from_airports = str_replace(',', ', ', $tourCode->from_airports);
                $tourCode->to_airports = str_replace(',', ', ', $tourCode->to_airports);
                $tourCode->period = date('d-M-Y', strtotime($tourCode->from_date)).' to '.date('d-M-Y', strtotime($tourCode->to_date));
                //echo "<pre>"; print_r($tourCode); die;
            }
        }
        if ($tourCodeData['status'] == 1) {
            return view('admin/tour-code/index')->with(['header'=>$header, 'appliedFilter'=>$appliedFilter, 'tourCodeDataCount'=>$tourCodeDataCount, 'tourCodeData'=>$tourCodeData,'queryStringConcat' => $queryStringConcat, 'i' => (request()->input('page', 1) - 1) * $appliedFilter['per_page']]);
        } else {
            return view('admin/tour-code/index')->with(['header'=>$header,'appliedFilter'=>$appliedFilter, 'tourCodeData'=>$tourCodeData,'tourCodeDataCount'=>$tourCodeDataCount,'queryStringConcat' => $queryStringConcat, 'i' => (request()->input('page', 1) - 1) * $appliedFilter['per_page']]);
        }
    }

    public function getAirports() {
        $getAirports = Airport::with('airportName')->where('status','active')->get()->toArray();
        $airports = [];
        if (count($getAirports) > 0) {
            foreach ($getAirports as $airport) {
                if ($airport['airport_name'][0]['language_code'] == Locale::English->value) {
                    $airportName = $airport['airport_name'][0]['airport_name'];
                } else {
                    $airportName = $airport['airport_name'][1]['airport_name'];
                }
                $airports[$airport['iata_code']] = $airportName;
            }
            asort($airports);
        }
        return $airports;
    }


    /**
     * Show the form for creating a new markups.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $header['title'] = "Tour Code - Add";
        $header['heading'] = "Tour Code - Add";

        $airports = $this->getAirports();

        return view('admin/tour-code/add')->with(['header' => $header, 'airports' => $airports]);;
    }

    /**
     * Store a newly created markups in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $requestData = $request->only([
            'tour_code',
            'from_airports',
            'to_airports',
            'from_date',
            'to_date',
            'status'
        ]);

        $rules = [
            'tour_code' => 'required',
            'from_airports' => 'required',
            'to_airports' => 'required',
            'from_date' => 'required',
            'to_date' => 'required',
            'status' => 'required'
        ];

        $customMessages = [];

        $niceNames = array();

        $this->validate($request, $rules, $customMessages, $niceNames);

        $requestData = [
            'tour_code' => $requestData['tour_code'],
            'from_airports' => implode(',', $requestData['from_airports']),
            'to_airports' => implode(',', $requestData['to_airports']),
            'from_date' => date('Y-m-d', strtotime($requestData['from_date'])),
            'to_date' => date('Y-m-d', strtotime($requestData['to_date'])),
            'status' => $requestData['status'],
        ];

        $response = TourCode::createTourCode($requestData);
        if (!empty($response['data'])) {
            return redirect()->route('tour-code.index', $response)->with('success', $response['message']);
        } else {
            return redirect()->back()->with('error', $response['message']);
        }
    }

    /**
     * Display the specified markups.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $header['title'] = "Tour Code - View";
        $header['heading'] = "Tour Code - View";

        $filter = array(
            'id' => $id
        );

        $response = TourCode::getTourCodes($filter);
        if ($response['status'] == 1 && !empty($response['data'])) {
            $airports = $this->getAirports();
            $tourCodeDetails = $response['data']->toArray();

            $tourCodeDetails['from_airports'] = implode('<br/>', $this->getAirportNames($airports, $tourCodeDetails['from_airports']));
            $tourCodeDetails['to_airports'] = implode('<br/>', $this->getAirportNames($airports, $tourCodeDetails['to_airports']));
            $tourCodeDetails['from_date'] = date('d-M-Y', strtotime($tourCodeDetails['from_date']));
            $tourCodeDetails['to_date'] = date('d-M-Y', strtotime($tourCodeDetails['to_date']));

            return view('admin/tour-code/view')->with(['header' => $header, 'tourCodeDetails' => $tourCodeDetails]);
        } else {
            return redirect()->route('tour-code.index')->with('error', $response['message']);
        }
    }

    /**
     * Show the form for editing the specified markups.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $header['title'] = "Flight - Edit";
        $header['heading'] = "Flight - Edit";

        $filter = array(
            'id' => $id
        );

        $response = TourCode::getTourCodes($filter);

        $airports = $this->getAirports();

        if ($response['status'] == 1 && !empty($response['data'])) {
            return view('admin/tour-code/edit')->with(['header' => $header, 'tourCodeDetails' => $response['data'], 'airports' => $airports]);
        } else {
            return redirect()->to('tour-code.index')->with('error', $response['message']);
        }
    }

    /**
     * Update the specified markups in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $requestData = $request->only([
            'id',
            'tour_code',
            'from_airports',
            'to_airports',
            'from_date',
            'to_date',
            'status'
        ]);

        $rules = [
            'id' => 'required',
            'tour_code' => 'required',
            'from_airports' => 'required',
            'to_airports' => 'required',
            'from_date' => 'required',
            'to_date' => 'required',
            'status' => 'required'
        ];

        $customMessages = [];

        $niceNames = array();

        $this->validate($request, $rules, $customMessages, $niceNames);

        $requestData = [
            'id' => $requestData['id'],
            'tour_code' => $requestData['tour_code'],
            'from_airports' => implode(',', $requestData['from_airports']),
            'to_airports' => implode(',', $requestData['to_airports']),
            'from_date' => date('Y-m-d', strtotime($requestData['from_date'])),
            'to_date' => date('Y-m-d', strtotime($requestData['to_date'])),
            'status' => $requestData['status'],
        ];

        $response = TourCode::updateTourCode($requestData);

        if ($response['status'] == 1 &&  !empty($response['data'])) {
            return redirect()->route('tour-code.index', $response)->with('success', $response['message']);
        } else {
            return redirect()->route('tour-code.index', $response)->with('error', $response['message']);

        }
    }

    /**
     * Remove the specified markups from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    /**
     * Display a listing of the markups.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function getListData() {
        $header['title']="Tour Code List";
        $header['heading']="Tour Code List";
        $queryStringConcat = '?';
        if (isset($_GET['per_page'])) {
            $queryStringConcat .= ($queryStringConcat == '') ? '?per_page=' . $_GET['per_page'] : '&per_page=' . $_GET['per_page'];
        }
        if (isset($_GET['page'])) {
            $queryStringConcat .= ($queryStringConcat == '') ? '?page=' . $_GET['page'] : '&page=' . $_GET['page'];
        }

        $appliedFilter = array(
            'per_page' => (request()->input('per_page') != NULL) ? request()->input('per_page') : Setting::where('config_key', 'general|setting|pagePerAdminRecords')->get('value')[0]['value'],
            'order_by' => (request()->input('order_by') != NULL) ? request()->input('order_by') : 'created_at',
            'sorting' => (request()->input('sorting') != NULL) ? request()->input('sorting') : 'desc',
            'origin' => (request()->input('origin') != NULL) ? request()->input('origin') : '',
            'destination' => (request()->input('destination') != NULL) ? request()->input('destination') : '',
        );

        if (request()->input('origin') != NULL) {
            $appliedFilter['where'][] = ['origin', '=', request()->input('origin')];
        }

        if (request()->input('destination') != NULL) {
            $appliedFilter['where'][] = ['destination', '=', request()->input('destination')];
        }

        $tourCodeDataList = TourCode::getTourCodes($appliedFilter);
        $tourCodeDataCount = TourCode::count();
        $tourCodeData = $tourCodeDataList['data'];
        if ($tourCodeData['status'] == 1) {
            return view('admin/tour-code/index')->with(['header'=>$header, 'appliedFilter'=>$appliedFilter, 'tourCodeDataCount'=>$tourCodeDataCount, 'tourCodeData'=>$tourCodeData,'queryStringConcat' => $queryStringConcat, 'i' => (request()->input('page', 1) - 1) * $appliedFilter['per_page']]);
        } else {
            return view('admin/tour-code/index')->with(['header'=>$header,'appliedFilter'=>$appliedFilter, 'tourCodeData'=>$tourCodeData,'tourCodeDataCount'=>$tourCodeDataCount,'queryStringConcat' => $queryStringConcat, 'i' => (request()->input('page', 1) - 1) * $appliedFilter['per_page']]);
        }
    }

    /**
     * Remove the specified markups from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function deleteTourCode($id)
    {
        if(!hasPermission('TourCodes','delete')){
            return view('admin/401');
        }
        $url = URL::previous();

        $response = TourCode::deleteTourCode($id);

        if ($response['status'] == 1) {
            return redirect()->to($url)->with('success', $response['message']);
        } else {
            return redirect()->to($url)->with('error', $response['message']);
        }
    }

}

