<?php

/**
 * @package     TrendingFlights
 * @subpackage   TrendingFlights
 * @Copyright(C) 2023 [Travel Portal].
 * @Version 1.0.0
 * module of the  TrendingFlights.
 */

namespace App\Http\Controllers\Admin;

use App\Enums\Locale;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Carbon;
use App\Models\Setting;
use App\Models\Airport;
use App\Models\SeoTrendingFlight;
use App\Traits\CommonService;
use DB;
use Illuminate\Support\Facades\Cache;
class SeoTrendingFlightsController extends Controller
{
    use CommonService;

    /**
     * Display a listing of the markups.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $header['title']="SEO Trending Flight List";
        $header['heading']="SEO Trending Flight List";
        $queryStringConcat = '?';
        if (isset($_GET['per_page'])) {
            $queryStringConcat .= ($queryStringConcat == '') ? '?per_page=' . $_GET['per_page'] : '&per_page=' . $_GET['per_page'];
        }
        if (isset($_GET['page'])) {
            $queryStringConcat .= ($queryStringConcat == '') ? '?page=' . $_GET['page'] : '&page=' . $_GET['page'];
        }

        $appliedFilter = array(
            'per_page' => (request()->input('per_page') != NULL) ? request()->input('per_page') : Setting::where('config_key', 'general|setting|pagePerAdminRecords')->get('value')[0]['value'],
            'order_by' => (request()->input('order_by') != NULL) ? request()->input('order_by') : 'created_at',
            'sorting' => (request()->input('sorting') != NULL) ? request()->input('sorting') : 'desc',
            'origin' => (request()->input('origin') != NULL) ? request()->input('origin') : '',
            'destination' => (request()->input('destination') != NULL) ? request()->input('destination') : '',
            'status' => (request()->input('status') != NULL) ? request()->input('status') : '',
        );

        if (request()->input('origin') != NULL) {
            $appliedFilter['where'][] = ['origin', '=', request()->input('origin')];
        }

        if (request()->input('destination') != NULL) {
            $appliedFilter['where'][] = ['destination', '=', request()->input('destination')];
        }

        $trendingFlightDataList = SeoTrendingFlight::getSeoTrendingFlights($appliedFilter);
        $trendingFlightDataCount = SeoTrendingFlight::count();

        $trendingFlightData = $trendingFlightDataList['data'];
        if ($trendingFlightData['status'] == 1) {
            return view('admin/seo-trending-flight/index')->with(['header'=>$header, 'appliedFilter'=>$appliedFilter, 'trendingFlightDataCount'=>$trendingFlightDataCount, 'trendingFlightData'=>$trendingFlightData,'queryStringConcat' => $queryStringConcat, 'i' => (request()->input('page', 1) - 1) * $appliedFilter['per_page']]);
        } else {
            return view('admin/seo-trending-flight/index')->with(['header'=>$header,'appliedFilter'=>$appliedFilter, 'trendingFlightData'=>$trendingFlightData,'trendingFlightDataCount'=>$trendingFlightDataCount,'queryStringConcat' => $queryStringConcat, 'i' => (request()->input('page', 1) - 1) * $appliedFilter['per_page']]);
        }
    }

   

    public function getAirportList() {
        $getAirportList = Airport::select('id', 'iata_code', 'country_code', 'city_code', 'latitude', 'longitude')
            ->with(['airportName' => function ($airport) {
                $airport->select(['airport_id', 'airport_name', 'language_code']);
            }, 'getCountry' => function ($country) {
                $country->select(['id', 'iso_code']);
            }, 'getCity' => function ($city) {
                $city->select(['id', 'iso_code']);
            }])
            ->orWhereHas('getCity.cityCode', function ($q) {
                $q->select(['city_name']);
            })
            ->orderByRaw("iata_code ASC")
            ->get()
            ->toArray();
        $getAirportList = collect($getAirportList)->map(function ($airport) {
            $airport_en = '';
            $airport_ar = '';
            $country_en = '';
            $country_ar = '';
            $city_en = '';
            $city_ar = '';

            foreach ($airport['airport_name'] as $airportName) {
                switch ($airportName['language_code']) {
                    case Locale::English->value:
                        $airport_en = $airportName['airport_name'];
                        break;
                    case Locale::Arabic->value:
                        $airport_ar = $airportName['airport_name'];
                        break;
                }
            }

            foreach ($airport['get_country']['country_code'] as $country) {
                switch ($country['language_code']) {
                    case Locale::English->value:
                        $country_en = $country['country_name'];
                        break;
                    case Locale::Arabic->value:
                        $country_ar = $country['country_name'];
                        break;
                }
            }

            foreach ($airport['get_city']['city_code'] as $city) {
                switch ($city['language_code']) {
                    case Locale::English->value:
                        $city_en = $city['city_name'];
                        break;
                    case Locale::Arabic->value:
                        $city_ar = $city['city_name'];
                        break;
                }
            }

            $display_name_en = $airport_en . ', ' . $city_en . ', ' . $country_en;
            $display_name_ar = $airport_ar . ', ' . $city_ar . ', ' . $country_ar;

            return [
                'id' => $airport['id'],
                'airport_code' => $airport['iata_code'],
                'airport_en' => $airport_en,
                'airport_ar' => $airport_ar,
                'display_name_en' => $display_name_en,
                'display_name_ar' => $display_name_ar,
                'city_en' => $city_en,
                'city_ar' => $city_ar,
            ];
        });

        return $getAirportList->values()->toArray();
    }

    public function getAirports() {
        $airportList = $this->getAirportList();
        $airports = [];
        foreach ($airportList as $airport) {
            $airports[$airport['id']] = $airport['airport_en'];
        }
        return $airports;
    }


    /**
     * Show the form for creating a new markups.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $header['title'] = "SEO Trending Flight - Add";
        $header['heading'] = "SEO Trending Flight - Add";

        $airports = $this->getAirports();

        return view('admin/seo-trending-flight/add')->with(['header' => $header, 'airports' => $airports]);;
    }

    /**
     * Store a newly created markups in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
     
        $requestData = $request->only([
            'from_airport',
            'to_airport',
            'status',
            'content',
            'arabic_content',
            'title',
            'arabic_title',
            'sub_title',
            'arabic_sub_title',
            'banner_title',
            'arabic_banner_title',
            'upload_banner',
            'banner_sub_title',
            'arabic_banner_sub_title'
        ]);

        $rules = [
            'from_airport' => 'required',
            'to_airport' => 'required',
            'status' => 'required',
            'content' => 'required',
            'arabic_content' => 'required',
            'banner_sub_title' => 'required',
            'arabic_banner_sub_title' => 'required',
            
        ];

        $customMessages = [];

        $niceNames = array();

        $this->validate($request, $rules, $customMessages, $niceNames);

        $airportList = $this->getAirportList();
        $airportListTemp = [];
        foreach($airportList as $key => $airport) {
            $airportListTemp[$airport['id']] = $airport;
        }
        $requestData = [
            'from_airport_id' => $requestData['from_airport'],
            'from_airport_name' => $airportListTemp[$requestData['from_airport']]['airport_en'],
            'from_airport' => $airportListTemp[$requestData['from_airport']]['airport_code'],
            'from_airport_city_en' => $airportListTemp[$requestData['from_airport']]['city_en'],
            'from_airport_city_ar' => $airportListTemp[$requestData['from_airport']]['city_ar'],
            'to_airport_id' => $requestData['to_airport'],
            'to_airport_name' => $airportListTemp[$requestData['to_airport']]['airport_en'],
            'to_airport' => $airportListTemp[$requestData['to_airport']]['airport_code'],
            'to_airport_city_en' => $airportListTemp[$requestData['to_airport']]['city_en'],
            'to_airport_city_ar' => $airportListTemp[$requestData['to_airport']]['city_ar'],
            'status' => $requestData['status'],
            'content' => $requestData['content'],
            'arabic_content' => $requestData['arabic_content'],
            'title' => $requestData['title'],
            'arabic_title' => $requestData['arabic_title'],
            'sub_title' => $requestData['sub_title'],
            'arabic_sub_title' => $requestData['arabic_sub_title'],
            'banner_title' => $requestData['banner_title'],
            'arabic_banner_title' => $requestData['arabic_banner_title'],
            'upload_banner' => $requestData['upload_banner'],
            'upload_banner' => $requestData['upload_banner'],
            'banner_sub_title' => $requestData['banner_sub_title'],
            'arabic_banner_sub_title' => $requestData['arabic_banner_sub_title'],
        ];



    


        $response = SeoTrendingFlight::createSeoTrendingFlight($requestData);
        if (!empty($response['data'])) {
            return redirect()->route('seo-trending-flight.index', $response)->with('success', $response['message']);
        } else {
            return redirect()->back()->with('error', $response['message']);
        }
    }

    /**
     * Display the specified markups.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $header['title'] = "SEO Trending Flight - View";
        $header['heading'] = "SEO Trending Flight - View";

        $filter = array(
            'id' => $id
        );

        $response = SeoTrendingFlight::getSeoTrendingFlights($filter);
        $airports = $this->getAirports();
        if ($response['status'] == 1 && !empty($response['data'])) {
            return view('admin/seo-trending-flight/view')->with(['header' => $header, 'trendingFlightDetails' => $response['data'], 'airports' => $airports]);
        } else {
            return redirect()->to('seo-trending-flight.index')->with('error', $response['message']);
        }
    }

    /**
     * Show the form for editing the specified markups.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $header['title'] = "SEO Trending Flight - Edit";
        $header['heading'] = "SEO Trending Flight - Edit";

        $filter = array(
            'id' => $id
        );

        $response = SeoTrendingFlight::getSeoTrendingFlights($filter);

        $airports = $this->getAirports();

        if ($response['status'] == 1 && !empty($response['data'])) {
            return view('admin/seo-trending-flight/edit')->with(['header' => $header, 'trendingFlightDetails' => $response['data'], 'airports' => $airports]);
        } else {
            return redirect()->to('seo-trending-flight.index')->with('error', $response['message']);
        }
    }

    /**
     * Update the specified markups in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        
        $requestData = $request->only([
            'id',
            'from_airport',
            'to_airport',
            'status',
            'content',
            'arabic_content',
            'title',
            'arabic_title',
            'sub_title',
            'arabic_sub_title',
            'banner_title',
            'arabic_banner_title',
            'upload_banner',
            'banner_sub_title',
            'arabic_banner_sub_title' 
        ]);

        $rules = [
            'id' => 'required',
            'from_airport' => 'required',
            'to_airport' => 'required',
            'status' => 'required',
            'content' => 'required',
            'arabic_content' => 'required',
            'banner_sub_title' => 'required',
            'arabic_banner_sub_title' => 'required',
        ];

        $customMessages = [];

        $niceNames = array();

        $this->validate($request, $rules, $customMessages, $niceNames);

        $airportList = $this->getAirportList();
        $airportListTemp = [];
        foreach($airportList as $key => $airport) {
            $airportListTemp[$airport['id']] = $airport;
        }
        $requestData = [
            'id' => $requestData['id'],
            'from_airport_id' => $requestData['from_airport'],
            'from_airport_name' => $airportListTemp[$requestData['from_airport']]['airport_en'],
            'from_airport' => $airportListTemp[$requestData['from_airport']]['airport_code'],
            'from_airport_city_en' => $airportListTemp[$requestData['from_airport']]['city_en'],
            'from_airport_city_ar' => $airportListTemp[$requestData['from_airport']]['city_ar'],
            'to_airport_id' => $requestData['to_airport'],
            'to_airport_name' => $airportListTemp[$requestData['to_airport']]['airport_en'],
            'to_airport' => $airportListTemp[$requestData['to_airport']]['airport_code'],
            'to_airport_city_en' => $airportListTemp[$requestData['to_airport']]['city_en'],
            'to_airport_city_ar' => $airportListTemp[$requestData['to_airport']]['city_ar'],
            'status' => $requestData['status'],
            'content' => $requestData['content'],
            'arabic_content' => $requestData['arabic_content'],

            'title' => $requestData['title'],
            'arabic_title' => $requestData['arabic_title'],
            'sub_title' => $requestData['sub_title'],
            'arabic_sub_title' => $requestData['arabic_sub_title'],
            'banner_title' => $requestData['banner_title'],
            'arabic_banner_title' => $requestData['arabic_banner_title'],
            'upload_banner' => $requestData['upload_banner'] ?? '',
            'banner_sub_title' => $requestData['banner_sub_title'],
            'arabic_banner_sub_title' => $requestData['arabic_banner_sub_title'],
        ];


        


        $response = SeoTrendingFlight::updateSeoTrendingFlight($requestData);

        if ($response['status'] == 1 &&  !empty($response['data'])) {
            return redirect()->route('seo-trending-flight.index', $response)->with('success', $response['message']);
        } else {
            return redirect()->route('seo-trending-flight.index', $response)->with('error', $response['message']);

        }
    }

    /**
     * Remove the specified markups from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    /**
     * Display a listing of the markups.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function getListData() {
        $header['title']="Trending Flight List";
        $header['heading']="Trending Flight List";
        $queryStringConcat = '?';
        if (isset($_GET['per_page'])) {
            $queryStringConcat .= ($queryStringConcat == '') ? '?per_page=' . $_GET['per_page'] : '&per_page=' . $_GET['per_page'];
        }
        if (isset($_GET['page'])) {
            $queryStringConcat .= ($queryStringConcat == '') ? '?page=' . $_GET['page'] : '&page=' . $_GET['page'];
        }

        $appliedFilter = array(
            'per_page' => (request()->input('per_page') != NULL) ? request()->input('per_page') : Setting::where('config_key', 'general|setting|pagePerAdminRecords')->get('value')[0]['value'],
            'order_by' => (request()->input('order_by') != NULL) ? request()->input('order_by') : 'created_at',
            'sorting' => (request()->input('sorting') != NULL) ? request()->input('sorting') : 'desc',
            'origin' => (request()->input('origin') != NULL) ? request()->input('origin') : '',
            'destination' => (request()->input('destination') != NULL) ? request()->input('destination') : '',
        );

        if (request()->input('origin') != NULL) {
            $appliedFilter['where'][] = ['origin', '=', request()->input('origin')];
        }

        if (request()->input('destination') != NULL) {
            $appliedFilter['where'][] = ['destination', '=', request()->input('destination')];
        }

        $trendingFlightDataList = SeoTrendingFlight::getTrendingFlights($appliedFilter);
        $trendingFlightDataCount = SeoTrendingFlight::count();
        $trendingFlightData = $trendingFlightDataList['data'];
        if ($trendingFlightData['status'] == 1) {
            return view('admin/seo-trending-flight/index')->with(['header'=>$header, 'appliedFilter'=>$appliedFilter, 'trendingFlightDataCount'=>$trendingFlightDataCount, 'trendingFlightData'=>$trendingFlightData,'queryStringConcat' => $queryStringConcat, 'i' => (request()->input('page', 1) - 1) * $appliedFilter['per_page']]);
        } else {
            return view('admin/seo-trending-flight/index')->with(['header'=>$header,'appliedFilter'=>$appliedFilter, 'trendingFlightData'=>$trendingFlightData,'trendingFlightDataCount'=>$trendingFlightDataCount,'queryStringConcat' => $queryStringConcat, 'i' => (request()->input('page', 1) - 1) * $appliedFilter['per_page']]);
        }
    }

    /**
     * Remove the specified markups from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function deleteSeoTrendingFlight($id)
    {
        if(!hasPermission('TrendingFlights','delete')){
            return view('admin/401');
        }
        $url = URL::previous();

        $response = SeoTrendingFlight::deleteSeoTrendingFlight($id);

        if ($response['status'] == 1) {
            return redirect()->to($url)->with('success', $response['message']);
        } else {
            return redirect()->to($url)->with('error', $response['message']);
        }
    }

}

