<?php

namespace App\Http\Controllers\Admin\SeoLinks;

use App\Models\Setting;
use Illuminate\Http\Request;
use App\Models\PopularAirline;
use Illuminate\Support\Facades\URL;
use App\Http\Controllers\Controller;

class PopularAirlineController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $header['title'] = "Popular Airlines";
        $header['heading'] = "Popular Airlines";
        $queryStringConcat = '?';
        if (isset($_GET['per_page'])) {
            $queryStringConcat .= ($queryStringConcat == '') ? '?per_page=' . $_GET['per_page'] : '&per_page=' . $_GET['per_page'];
        }
        if (isset($_GET['page'])) {
            $queryStringConcat .= ($queryStringConcat == '') ? '?page=' . $_GET['page'] : '&page=' . $_GET['page'];
        }

        $appliedFilter = array(
            'per_page' => (request()->input('per_page') != NULL) ? request()->input('per_page') : Setting::where('config_key', 'general|setting|pagePerAdminRecords')->get('value')[0]['value'],
            'order_by' => (request()->input('order_by') != NULL) ? request()->input('order_by') : 'created_at',
            'sorting' => (request()->input('sorting') != NULL) ? request()->input('sorting') : 'desc',
            'origin' => (request()->input('origin') != NULL) ? request()->input('origin') : '',
            'name' => (request()->input('name') != NULL) ? request()->input('name') : '',
            'status' => (request()->input('status') != NULL) ? request()->input('status') : '',
        );

        if (request()->input('name') != NULL) {
            $appliedFilter['where'][] = ['name', '=', request()->input('name')];
        }

        if (request()->input('status') != NULL) {
            $appliedFilter['where'][] = ['status', '=', request()->input('status')];
        }

        $popularAirlineDataList = PopularAirline::getPopularAirlines($appliedFilter);
        $popularAirlineDataCount = PopularAirline::count();

        $popularAirlineData = $popularAirlineDataList['data'];
        if ($popularAirlineData['status'] == 1) {
            return view('admin/popular-airline/index')->with(['header' => $header, 'appliedFilter' => $appliedFilter, 'popularAirlineCount' => $popularAirlineDataCount, 'popularAirline' => $popularAirlineData, 'queryStringConcat' => $queryStringConcat, 'i' => (request()->input('page', 1) - 1) * $appliedFilter['per_page']]);
        } else {
            return view('admin/popular-airline/index')->with(['header' => $header, 'appliedFilter' => $appliedFilter, 'popularAirlineData' => $popularAirlineData, 'popularAirlineCount' => $popularAirlineDataCount, 'queryStringConcat' => $queryStringConcat, 'i' => (request()->input('page', 1) - 1) * $appliedFilter['per_page']]);
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $header['title'] = "Popular Airlines- Add";
        $header['heading'] = "Popular Airlines - Add";


        return view('admin/popular-airline/add')->with(['header' => $header]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $requestData = $request->only([
            'name',
            'popular_url',
            'status',
            'content',
            'arabic_content',
            'title',
            'arabic_title',
            'sub_title',
            'arabic_sub_title',
            'banner_title',
            'arabic_banner_title',
            'upload_banner',
            'banner_sub_title',
            'arabic_banner_sub_title'
        ]);

        $rules = [
            'name' => 'required|string|max:255',
            'popular_url' => 'required | url',
            'status' => 'required',
            'content' => 'required',
            'arabic_content' => 'required',
            'banner_sub_title' => 'required',
            'arabic_banner_sub_title' => 'required',
        ];

        $customMessages = [];

        $niceNames = array();

        $this->validate($request, $rules, $customMessages, $niceNames);
        if (isset($requestData['upload_banner'])) {

            //upload profile image
            try {
                $destinationPath = storage_path() . '/app/public/seo_banner/';
                if (!is_dir($destinationPath)) {
                    /* Directory does not exist, so lets create it. */
                    mkdir($destinationPath, 0777);
                }
                $file = $requestData['upload_banner'];
                $fileName =  uniqid() . '_' .  time() . '.' . $requestData['upload_banner']->extension();
                $file->move($destinationPath, $fileName);
                $url = 'seo_banner/' . $fileName;

                $newFileName = $url;
            } catch (\Exception $e) {
                $return['message'] = 'Error during save home banner image : ' . $e->getMessage();
            }
        }

        $popularAirline = PopularAirline::create(
            [
                'name' => $requestData['name'],
                'url' => $requestData['popular_url'],
                'status' => $requestData['status'],
                'content' => $requestData['content'] ?? '',
                'arabic_content' => $requestData['arabic_content'],
                'title' => $requestData['title'] ?? '',
                'arabic_title' => $requestData['arabic_title'] ?? '',
                'sub_title' => $requestData['sub_title'] ?? '',
                'arabic_sub_title' => $requestData['arabic_sub_title'] ?? '',
                'banner_title' => $requestData['banner_title'] ?? '',
                'arabic_banner_title' => $requestData['arabic_banner_title'] ?? '',
                'banner' => $newFileName ?? '',
                'banner_sub_title' => $requestData['banner_sub_title'] ?? '',
                'arabic_banner_sub_title' => $requestData['arabic_banner_sub_title'] ?? '',

            ]
        );
        if ($popularAirline) {
            return redirect()->route('popular-airline.index')->with('success', 'Popular Attraction Created Successully');
        } else {
            return redirect()->back()->with('error','Error Creating Popular Attraction');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $header['title'] = "Popular Airlines - View";
        $header['heading'] = "Popular Airlines - View";
    
       
        $popularAirlineDetails = PopularAirline::where('id', $id)->get();
    
       
        if (!$popularAirlineDetails->isEmpty()) {
           
            return view('admin/popular-airline/view')->with([
                'header' => $header,
                'popularAirlineDetails' => $popularAirlineDetails->first(), 
            ]);
        } else {
            return redirect()->route('popular-airline.index')->with('error', 'Error');
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $header['title'] = "Popular Airlines - View";
        $header['heading'] = "Popular Airlines - View";
    
      
        $popularAirlineDetails=PopularAirline::where('id', $id)->get();
    
     
        if (!$popularAirlineDetails ->isEmpty()) {
       
            return view('admin/popular-airline/update')->with([
                'header' => $header,
                'popularAirlineDetails' => $popularAirlineDetails ->first(), 
            ]);
        } else {
            return redirect()->route('popular-airline.index')->with('error', 'Error');
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $requestData = $request->only([
            'name',
            'popular_url',
            'status',
            'content',
            'arabic_content',
            'title',
            'arabic_title',
            'sub_title',
            'arabic_sub_title',
            'banner_title',
            'arabic_banner_title',
            'upload_banner',
            'banner_sub_title',
            'arabic_banner_sub_title'
        ]);

        $rules = [
            'name' => 'required|string|max:255',
            'popular_url' => 'required | url',
            'status' => 'required',
            'content' => 'required',
            'arabic_content' => 'required',
            'banner_sub_title' => 'required',
            'arabic_banner_sub_title' => 'required',
        ];
    
      
        $this->validate($request, $rules);
    
      
        $popularAirline = PopularAirline::find($id);
    
       
        if (! $popularAirline) {
            return redirect()->route('popular-airline.index')->with('error', 'Popular Airlines not found');
        }

        if (isset($requestData['upload_banner'])) {

            //upload profile image
            try {
                $destinationPath = storage_path() . '/app/public/seo_banner/';
                if (!is_dir($destinationPath)) {
                    /* Directory does not exist, so lets create it. */
                    mkdir($destinationPath, 0777);
                }
                $file = $requestData['upload_banner'];
                $fileName =  uniqid() . '_' .  time() . '.' . $requestData['upload_banner']->extension();
                $file->move($destinationPath, $fileName);
                $url = 'seo_banner/' . $fileName;

                $popularAirline->banner= $url;
            } catch (\Exception $e) {
                $return['message'] = 'Error during save home banner image : ' . $e->getMessage();
            }
        }
    
      
        $popularAirline->name = $requestData['name'];
        $popularAirline->url = $requestData['popular_url'];
        $popularAirline->status = $requestData['status'];
        $popularAirline->content = $requestData['content'] ?? '';
        $popularAirline->arabic_content = $requestData['arabic_content'];
        $popularAirline->title = $requestData['title'] ?? '';
        $popularAirline->arabic_title = $requestData['arabic_title'] ?? '';
        $popularAirline->sub_title = $requestData['sub_title'] ?? '';
        $popularAirline->arabic_sub_title = $requestData['arabic_sub_title'] ?? '';
        $popularAirline->banner_title = $requestData['banner_title'] ?? '';
        $popularAirline->arabic_banner_title = $requestData['arabic_banner_title'] ?? '';
        $popularAirline->banner_sub_title = $requestData['banner_sub_title'] ?? '';
        $popularAirline->arabic_banner_sub_title = $requestData['arabic_banner_sub_title'] ?? '';
    
        
        if ($popularAirline->save()) {
            return redirect()->route('popular-airline.index')->with('success', 'Popular Attraction updated successfully');
        } else {
            return redirect()->back()->with('error', 'Error updating Popular Airlines');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }


    public function  deletePopularAirline($id)
    {
        
        $popularAirline = PopularAirline::find($id);
    
        
        if (!$popularAirline) {
            return redirect()->route('popular-airline.index')->with('error', 'PopularAirline not found');
        }
    
        $url = URL::previous();
        if ($popularAirline->delete()) {
         
            return redirect()->to($url)->with('success','Popular Airline deleted successfully');
        } else {
            return redirect()->to($url)->with('error', 'Error deleting Popular Airline');
   
        }
    }
}

