<?php

namespace App\Http\Controllers\Admin\SeoLinks;

use App\Models\Setting;
use App\Models\Multimedia;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\URL;
use App\Http\Controllers\Controller;

class MultimediaController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $header['title'] = "Multimedia";
        $header['heading'] = "Multimedia";
        $queryStringConcat = '?';
        if (isset($_GET['per_page'])) {
            $queryStringConcat .= ($queryStringConcat == '') ? '?per_page=' . $_GET['per_page'] : '&per_page=' . $_GET['per_page'];
        }
        if (isset($_GET['page'])) {
            $queryStringConcat .= ($queryStringConcat == '') ? '?page=' . $_GET['page'] : '&page=' . $_GET['page'];
        }

        $appliedFilter = array(
            'per_page' => (request()->input('per_page') != NULL) ? request()->input('per_page') : Setting::where('config_key', 'general|setting|pagePerAdminRecords')->get('value')[0]['value'],
            'order_by' => (request()->input('order_by') != NULL) ? request()->input('order_by') : 'created_at',
            'sorting' => (request()->input('sorting') != NULL) ? request()->input('sorting') : 'desc',
            'origin' => (request()->input('origin') != NULL) ? request()->input('origin') : '',
            'name' => (request()->input('name') != NULL) ? request()->input('name') : '',
            'status' => (request()->input('status') != NULL) ? request()->input('status') : '',
        );

        if (request()->input('name') != NULL) {
            $appliedFilter['where'][] = ['name', '=', request()->input('name')];
        }

        if (request()->input('status') != NULL) {
            $appliedFilter['where'][] = ['status', '=', request()->input('status')];
        }

        $multimediaLinkDataList = Multimedia::getMultimedia($appliedFilter);
        $multimediaLinkDataCount = Multimedia::count();

        $multimediaLinkData = $multimediaLinkDataList['data'];
        if ($multimediaLinkData['status'] == 1) {
            return view('admin/multimedia/index')->with(['header' => $header, 'appliedFilter' => $appliedFilter, 'multimediaLinkCount' => $multimediaLinkDataCount, 'multimediaLinkData' => $multimediaLinkData, 'queryStringConcat' => $queryStringConcat, 'i' => (request()->input('page', 1) - 1) * $appliedFilter['per_page']]);
        } else {
            return view('admin/multimedia/index')->with(['header' => $header, 'appliedFilter' => $appliedFilter, 'multimediaLinkData' => $multimediaLinkData, 'multimediaLinkDataCount' => $multimediaLinkDataCount, 'queryStringConcat' => $queryStringConcat, 'i' => (request()->input('page', 1) - 1) * $appliedFilter['per_page']]);
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $header['title'] = "Multimedia- Add";
        $header['heading'] = "Multimedia - Add";


        return view('admin/multimedia/add')->with(['header' => $header]);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $requestData = $request->only([
            'name',
            'multimedia_url',
            'video',
            'status'
        ]);

        $rules = [
            'name' => 'required|string|max:255',
            'url' => 'url',
            'video' => '',
            'status' => 'required',
        ];

        $customMessages = [];

        $niceNames = array();

        $this->validate($request, $rules, $customMessages, $niceNames);

        if ($request->hasFile('video')) {
            $imagePath = $request->file('video')->store('multimedia', 'public');
            
        }

        $multimediaLink = Multimedia::create(
            [
                'name' => $requestData['name'],
                'url' => $requestData['multimedia_url'],
                'video_audio' => $imagePath,
                'status' => $requestData['status'],

            ]
        );
        if ($multimediaLink) {
            return redirect()->route('multimedia.index')->with('success', 'Multimedia Created Successully');
        } else {
            return redirect()->back()->with('error','Error Creating Multimedia');
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $header['title'] = "Multimedia - View";
        $header['heading'] = "Multimedia - View";
    
       
        $multimediaLinkDetails = Multimedia::where('id', $id)->get();
    
       
        if (!$multimediaLinkDetails->isEmpty()) {
           
            return view('admin/multimedia/view')->with([
                'header' => $header,
                'multimediaLinkDetails' => $multimediaLinkDetails->first(), 
            ]);
        } else {
            return redirect()->route('multimedia.index')->with('error', 'Error');
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $header['title'] = "Multimedia - Edit";
        $header['heading'] = "Multimedia - Edit";
    
      
        $multimediaLinkDetails  =Multimedia::where('id', $id)->get();
    
     
        if (!$multimediaLinkDetails ->isEmpty()) {
       
            return view('admin/multimedia/update')->with([
                'header' => $header,
                'multimediaLinkDetails' => $multimediaLinkDetails ->first(), 
            ]);
        } else {
            return redirect()->route('multimedia.index')->with('error', 'Error');
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $requestData = $request->only([
            'name',
            'multimedia_url',
            'video',
            'status'
        ]);

        $rules = [
            'name' => 'required|string|max:255',
            'url' => 'url',
            'video' => '',
            'status' => 'required',
        ];
    
      
        $this->validate($request, $rules);
    
      
        $multimediaLink = Multimedia::find($id);
    
       
        if (! $multimediaLink) {
            return redirect()->route('multimedia.index')->with('error', 'Multimedia not found');
        }
    

      
        $multimediaLink->name = $requestData['name'];
        $multimediaLink->url = $requestData['multimedia_url'];
        $multimediaLink->status = $requestData['status'];
         if ($request->hasFile('video')) {
            $imagePath = $request->file('video')->store('multimedia', 'public');
            $multimediaLink->video_audio =$imagePath;
            
        }
        
        if ($multimediaLink->save()) {
            return redirect()->route('multimedia.index')->with('success', 'Multimedia updated successfully');
        } else {
            return redirect()->back()->with('error', 'Error updating Multimedia');
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function  deleteMultimedia($id)
    {
        
        $multimediaLink = Multimedia::find($id);
    
        
        if (!$multimediaLink) {
            return redirect()->route('multimedia.index')->with('error', 'Multimedia not found');
        }
    
        $url = URL::previous();
        if ($multimediaLink->delete()) {
         
            return redirect()->to($url)->with('success','Multimedia deleted successfully');
        } else {
            return redirect()->to($url)->with('error', 'Error deleting Multimedia');
   
        }
    }
}
