<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Traits\ActiveLog;
use App\Traits\AmadeusService;
use App\Traits\BookingService;
use App\Traits\CommonService;
use App\Traits\EmailService;
use App\Traits\PaymentService;
use App\Traits\HotelBeds;
use App\Traits\SmsService;
use App\Traits\WhatsappService;
use Illuminate\Support\Facades\DB;
use App\Models\Bookings;
use App\Models\Suppliers;
use App\Models\Agency;
use App\Models\ServiceType;
use App\Models\Setting;
use App\Models\Payment;
use Carbon\Carbon;
use ZipArchive;
use Illuminate\Support\Facades\Storage;
use Illuminate\Http\File;
use Illuminate\Support\Facades\URL;
use DataTables;

class ScheduleController extends Controller
{
    use AmadeusService, BookingService, CommonService, EmailService, HotelBeds, SmsService,WhatsappService, ActiveLog, PaymentService;

    public function __construct()
    {
        $this->perPage = count(Setting::where('config_key', 'general|setting|pagePerAPIRecords')->get('value')) > 0 ? Setting::where('config_key', 'general|setting|pagePerAPIRecords')->get('value')[0]['value'] : "20";

        //set AMADEUS API configuration from config key
        $this->amadeusAPIEnvironment = env('AMADEUS_API_CREDENTIALS');

        if ($this->amadeusAPIEnvironment == 'test') {
            $this->amadeusAPIEndPoint = env('AMADEUS_API_TEST_API_ENDPOINT');
            $this->amadeusAPIClientID = env('AMADEUS_API_TEST_CLIENT_ID');
            $this->amadeusAPIClientSecret = env('AMADEUS_API_TEST_CLIENT_SECRET');
            $this->amadeusAPIGrantType = env('AMADEUS_API_TEST_GRANT_TYPE');
        } else {
            $this->amadeusAPIEndPoint = env('AMADEUS_API_LIVE_API_ENDPOINT');
            $this->amadeusAPIClientID = env('AMADEUS_API_LIVE_CLIENT_ID');
            $this->amadeusAPIClientSecret = env('AMADEUS_API_LIVE_CLIENT_SECRET');
            $this->amadeusAPIGrantType = env('AMADEUS_API_LIVE_GRANT_TYPE');
        }

        $this->amadeusAPISecret = env('AMADEUS_API_SECRET');
    }
	public function backupdb()
    {
		
		$hostname = env('DB_HOST', '127.0.0.1');
		$username  = env('DB_USERNAME', 'forge');
		$password = env('DB_PASSWORD', '');
		$dbname = env('DB_DATABASE', 'forge');

		//delete old database backup start
		$path = 'data/';  
		 $files = glob($path."*");
		
		  $now   = time();
		$count = 0;
		  foreach ($files as $file) {
			if (is_file($file)) {
			  if ($now - filemtime($file) >= 60 * 60 * 24 * 2) { // 90 days
				unlink($file);
				//echo $file."<br>";
				$count++;
			  }
			}
		  }
		//delete old database backup End

		// if mysqldump is on the system path you do not need to specify the full path
		// simply use "mysqldump --add-drop-table ..." in this case
		$dumpfname = "data/".$dbname . "_" . date("Y-m-d_H-i-s").".sql";
		$command = "mysqldump --add-drop-table --host=$hostname --user=$username ";

		$command.= "--password='". $password ."' ";
		$command.= $dbname;
		$command.= " > " . $dumpfname;
		
		exec($command);
		die;
		//die("hai");	
	}
	public function sendwhatsapp($bookingId) {
		
        $savedBookingDetails = Bookings::where('id', $bookingId)->first()->toArray();
		$this->sendBookingWhatsapp($savedBookingDetails);
		die;
		
    }
    public function index(Request $request)
    {
		
        // $results = Bookings::get();
        // $dataList = array();
        // foreach($results as $result)
        // {
        //     $dataList[] = array('id'=>$result->id, 'sub_total' => $result->sub_total);
        // }
        //print_r($dataList);
        //exit;
        $supplierDataList = Suppliers::get()->toArray();
        $suppliers = [];
        if ($supplierDataList) {
            foreach($supplierDataList as $value) {
            $suppliers[$value['id']] = $value['name'];
            }
        }
        if ($request->ajax()) {
            $i = 0;
            //$results = Bookings::latest()->get();//->orderBy('created_at', 'DESC')
            $results = Bookings::select('*')->orderBy('created_at', 'DESC');
            return DataTables::of($results)
                ->addIndexColumn()
                ->filter(function ($instance) use ($request) {
                    if ($request->get('booking_date')) {
                        $instance->where('booking_date', date("Y-m-d", strtotime($request->get('booking_date'))));
                    }
                    if ($request->get('supplier_id')) {
                        $instance->where('supplier_id', $request->get('supplier_id'));
                    }
                    if ($request->get('service_id')) {
                        $instance->where('service_id', $request->get('service_id'));
                    }
                    if ($request->get('system_ref_id')) {
                        $system_ref_id = $request->get('system_ref_id');
                        $instance->where('supplier_booking_ref', 'like', '%' . $system_ref_id . '%');
                    }
                    if ($request->get('booking_id')) {
                        $booking_ref = $request->get('booking_ref');
                        $instance->where('booking_ref', 'like', '%' . $booking_ref . '%');
                    }
                    if ($request->get('price_from')) {
                        $instance->where('total', '>=', $request->get('price_from'));
                    }
                    if ($request->get('price_to')) {
                        $instance->where('total', '<=', $request->get('price_to'));
                    }
                    if ($request->get('pnr_number')) {
                        $pnr_number = $request->get('pnr_number');
                        //$instance->where('pnr_number', 'like', '%' . $pnr_number . '%');
                    }
                    if ($request->get('customer_id')) {
                        $instance->where('customer_id', $request->get('customer_id'));
                    }
                    if ($request->get('booking_status')) {
                        $instance->where('booking_status', $request->get('booking_status'));
                    }
                    if ($request->get('payment_status')) {
                        //$instance->where('payment_status', $request->get('payment_status'));
                    }
                    if ($request->get('agency_id')) {
                        $instance->where('agency_id', $request->get('agency_id'));
                    }
                    if ($request->has('search') && ! is_null($request->get('search')['value']) ) {
                        $regex = $request->get('search')['value'];
                        $instance->where('booking_ref', 'like', '%' . $regex . '%');
                    }
                })
                ->addColumn("booking_type", function ($data) {
                    if (empty($data->booking_type)) {
                        return "N/A";
                    }
                    return $data->booking_type;
                })
                ->addColumn("supplier_booking_ref", function ($data) {
                    if (empty($data->supplier_booking_ref)) {
                        return "N/A";
                    }
                    return $data->supplier_booking_ref;
                })
                ->addColumn("booking_ref", function ($data) {
                    if (empty($data->booking_ref)) {
                        return "N/A";
                    }
                    return '<a href="'. route('booking.show',$data->id).'" title="View">'.$data->booking_ref.'</a>';
                })
                ->addColumn("supplier_id", function ($data) use ($suppliers) {
                    if (empty($data->supplier_id)) {
                        return "N/A";
                    }
                    return $suppliers[$data->supplier_id];
                })
                ->addColumn("total", function ($data) {
                    if (empty($data->total)) {
                        return "N/A";
                    }
                    return $data->total;
                })
                ->addColumn("booking_cancel_amount", function ($data) {
                    if ($data->booking_cancel_amount == '') {
                        return "N/A";
                    }
                    if ($data->booking_cancel_amount != '' && $data->processed_cancel_amount == '' && $data->processed_cancel_amount != '0.00') {
                        $bookingCancelAmount = ($data['booking_status'] == 'cancelled not refunded') ? $data->total : $data->booking_cancel_amount;
                        return $bookingCancelAmount.'<br/><a href="#" class="refund-booking" data-id="'.$data->id.'" data-amount="'.$bookingCancelAmount.'" title="Refund">Refund</a>';
                    }
                    return $data->booking_cancel_amount;
                })
                ->addColumn("processed_cancel_amount", function ($data) {
                    if ($data->processed_cancel_amount == '') {
                        return "N/A";
                    }
                    return $data->processed_cancel_amount;
                })
                ->addColumn("is_guest", function ($data) {
                    return ($data->is_guest == 'true')? 'Yes' : 'No';
                })
                ->addColumn("email", function ($data) {
                    if (empty($data->email)) {
                        return "N/A";
                    }
                    return $data->email;
                })
                ->addColumn("phone", function ($data) {
                    if (empty($data->phone)) {
                        return "N/A";
                    }
                    return $data->phone_country_code.$data->phone;
                })
                ->addColumn("description", function ($data) {
                    if (empty($data->description)) {
                        return "N/A";
                    }
                    return $data->description;
                })
                ->addColumn("booking_date", function ($data) {
                    if (empty($data->booking_date)) {
                        return "N/A";
                    }
                    return getDateTimeZone($data->booking_date);
                })
                ->addColumn("pnr_number", function ($data) {
                    if (empty($data->pnr_number)) {
                        return "N/A";
                    }
                    return $data->pnr_number;
                })
                ->addColumn("booking_status", function ($data) {
                    if (empty($data->booking_status)) {
                        return "N/A";
                    }
                    $bookingStatusContent = '
                    <div class="booking-status '.$data->booking_status.'">
                        '.ucfirst($data['booking_status']);
                    if($data['booking_status'] != 'confirmed' && $data->booking_sub_status != '') {
                        $bookingStatusContent .= ': '.$data->booking_sub_status;
                    }
                    if($data['booking_status'] != 'confirmed' && $data->booking_status_message != '') {
                        $bookingStatusContent .= '<br/><span class="booking-status-message">('.$data->booking_status_message.')</span>';
                    }
                    $bookingStatusContent .= '</div>';

                    return $bookingStatusContent;
                })
                ->addColumn("action", function ($data) {
                    $actionContent = '
                    <a href="'. route('booking.show',$data->id).'" title="View">
                        <svg xmlns="http://www.w3.org/2000/svg" fill="#2188ef"
                        width="20" height="20" x="0px" y="0px" viewBox="0 0 576 512"><path d="M288 80c-65.2 0-118.8 29.6-159.9 67.7C89.6 183.5 63 226 49.4 256c13.6 30 40.2 72.5 78.6 108.3C169.2 402.4 222.8 432 288 432s118.8-29.6 159.9-67.7C486.4 328.5 513 286 526.6 256c-13.6-30-40.2-72.5-78.6-108.3C406.8 109.6 353.2 80 288 80zM95.4 112.6C142.5 68.8 207.2 32 288 32s145.5 36.8 192.6 80.6c46.8 43.5 78.1 95.4 93 131.1c3.3 7.9 3.3 16.7 0 24.6c-14.9 35.7-46.2 87.7-93 131.1C433.5 443.2 368.8 480 288 480s-145.5-36.8-192.6-80.6C48.6 356 17.3 304 2.5 268.3c-3.3-7.9-3.3-16.7 0-24.6C17.3 208 48.6 156 95.4 112.6zM288 336c44.2 0 80-35.8 80-80s-35.8-80-80-80c-.7 0-1.3 0-2 0c1.3 5.1 2 10.5 2 16c0 35.3-28.7 64-64 64c-5.5 0-10.9-.7-16-2c0 .7 0 1.3 0 2c0 44.2 35.8 80 80 80zm0-208a128 128 0 1 1 0 256 128 128 0 1 1 0-256z"/></svg>
                    </a>
                    <a href="'. route('admin.booking.supplier-log',$data->id) .'" target="blank" class="log-booking" title="Log">
                        <img src="'. URL::asset('assets/images/icon-zip.png') .'" width="20" height="20" />
                    </a>
                    ';
                    if ($data->booking_status == 'confirmed') {
                        $actionContent .= '
                        <a href="#" class="cancel-booking" data-id="'.$data->id.'" title="Cancel">
                            <svg xmlns="http://www.w3.org/2000/svg" fill="#FF0000" width="20" height="20" viewBox="0 0 384 512"><path d="M342.6 150.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L192 210.7 86.6 105.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L146.7 256 41.4 361.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L192 301.3 297.4 406.6c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L237.3 256 342.6 150.6z"/></svg>
                        </a>';
                    }
                    return $actionContent;
                })
                ->rawColumns(["action", "booking_ref", "booking_status", "booking_cancel_amount"])
                ->make(true);
        }
        $data["title"] = "Manage Booking";
        $data['heading'] = "Booking";
        $data['supplierDataList'] = $supplierDataList;
        $data['getServiceType'] = ServiceType::get()->toArray();
        $data['getAgency'] = Agency::get()->toArray();
        return view("admin.booking.index", $data);
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index_old()
    {
        $header['title'] = "Booking";
        $header['heading'] = "Booking";

        $queryStringConcat = '?';
        if (isset($_GET['per_page'])) {
            $queryStringConcat .= ($queryStringConcat == '') ? '?per_page=' . $_GET['per_page'] : '&per_page=' . $_GET['per_page'];
        }
        if (isset($_GET['page'])) {
            $queryStringConcat .= ($queryStringConcat == '') ? '?page=' . $_GET['page'] : '&page=' . $_GET['page'];
        }
        $filter = array(
            'per_page' => (request()->input('per_page') != NULL) ? request()->input('per_page') : Setting::where('config_key', 'general|setting|pagePerAdminRecords')->get('value')[0]['value'],
            'order_by' => (request()->input('order_by') != NULL) ? request()->input('order_by') : 'created_at',
            'sorting' => (request()->input('sorting') != NULL) ? request()->input('sorting') : 'desc',
            'supplier_id' => (request()->input('supplier_id') != NULL) ? request()->input('supplier_id') : '',
            'service_id' => (request()->input('service_id') != NULL) ? request()->input('service_id') : '',
            'booking_id' => (request()->input('booking_id') != NULL) ? request()->input('booking_id') : '',
            'booking_status' => (request()->input('booking_status') != NULL) ? request()->input('booking_status') : '',
            'agency_id' => (request()->input('agency_id') != NULL) ? request()->input('agency_id') : '',
            'status' => (request()->input('status') != NULL) ? request()->input('status') : '',
        );
        if (request()->input('full_name') != NULL) {
            $fullName = request()->input('full_name');
            $filter['where'][] = [
                DB::raw("CONCAT(first_name, ' ', last_name)"),
                'LIKE',
                '%' . $fullName . '%'
            ];
        }
        if (request()->input('booking_date') != NULL) {
            $filter['where'][] = ['booking_date', 'like', '%' . request()->input('booking_date') . '%'];
        }
        if (request()->input('supplier_id') != NULL) {
            $filter['where'][] = ['supplier_id', '=', request()->input('supplier_id') ];
        }
        if (request()->input('service_id') != NULL) {
            $filter['where'][] = ['service_id', '=', request()->input('service_id') ];
        }
        if (request()->input('booking_id') != NULL) {
            $filter['where'][] = ['id', '=', request()->input('booking_id') ];
        }
        if (request()->input('booking_status') != NULL) {
            $filter['where'][] = ['booking_status', '=', request()->input('booking_status') ];
        }
        if (request()->input('agency_id') != NULL) {
            $filter['where'][] = ['agency_id', '=', request()->input('agency_id') ];
        }
        if (request()->input('customer_name') != NULL) {
            $fullName = request()->input('customer_name');
            $filter['whereHas'][] = [
                DB::raw("CONCAT(first_name, ' ', last_name)"),
                'LIKE',
                '%' . $fullName . '%'
            ];
        }

        if (request()->input('email') != NULL) {
            $filter['where'][] = ['customers.email', 'like', '%' . request()->input('email') . '%'];
        }
        if (request()->input('price_from') != NULL) {
            $filter['where'][] = ['sub_total', '>=', request()->input('price_from')];
        }
        if (request()->input('price_to') != NULL) {
            $filter['where'][] = ['sub_total', '<=', request()->input('price_to')];
        }
        if (request()->input('status') != NULL) {
            $filter['where'][] = ['customers.status', '=', request()->input('status')];
        }
        // echo "<pre>";print_r($filter);die;
        $bookingListData = Bookings::getBookings($filter);
        $bookingDataCount = Bookings::count();
        $bookingData = $bookingListData['data'];
        $supplierDataList = Suppliers::get()->toArray();
        $getServiceType = ServiceType::get()->toArray();
        $getAgency = Agency::get()->toArray();
        $activityLog['request'] =  request()->input();
        $activityLog['request_url'] =  request()->url();
        $activityLog['response'] =  $bookingData;
        ActiveLog::createBackendActiveLog($activityLog);
        $suppliers = [];
        if ($supplierDataList) {
            foreach($supplierDataList as $value) {
                $suppliers[$value['id']] = $value['name'];
            }
        }

        if ($bookingListData['status'] == 1) {
            return view('admin/booking/index')->with(['header' => $header, 'getAgency' => $getAgency, 'getServiceType' => $getServiceType, 'supplierDataList' => $supplierDataList, 'suppliers' => $suppliers,'bookingData' => $bookingData, 'bookingDataCount' => $bookingDataCount, 'queryStringConcat' => $queryStringConcat, 'appliedFilter' => $filter, 'i' => (request()->input('page', 1) - 1) * $filter['per_page']]);
        } else {
            return view('admin/booking/index')->with(['error' => $bookingListData['message'], 'header' => $header, 'bookingData' => $bookingData, 'bookingDataCount' => $bookingDataCount, 'queryStringConcat' => $queryStringConcat, 'appliedFilter' => $filter, 'i' => (request()->input('page', 1) - 1) * $filter['per_page']]);
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id,$mode="download")
    {
        $header['title'] = "View Booking";
        $header['heading'] = "View Booking";

        $filter = array(
            'id' => $id
        );

        //echo "<pre>";print_r($filter);die;
        $bookingListData = Bookings::getBookings($filter);
        $bookingDataCount = Bookings::count();
        $bookingData = $bookingListData['data'];

        $supplierDataList = Suppliers::get()->toArray();
        $getServiceType = ServiceType::get()->toArray();
        $getAgency = Agency::get()->toArray();
        $activityLog['request'] =  request()->input();
        $activityLog['request_url'] =  request()->url();
        $activityLog['response'] =  $bookingData;
		//echo "<pre>";
		//print_r($bookingData);die;
       // ActiveLog::createBackendActiveLog($activityLog);
		//echo "<pre>";
		//print_r($bookingData);die;
        if (!empty($bookingData)) {
			if($mode == "download"){
				if($bookingData->booking_type == "Hotel") {
					 $supplierResponse = json_decode($bookingData->service_provider_response, true);
					 $bookingNotes = 'Payable through '.$supplierResponse['booking']['hotel']['supplier']['name'].', acting as agent for the service operating company, details of which can be provided upon request. VAT: '.$supplierResponse['booking']['hotel']['supplier']['vatNumber'].' Reference: '.$supplierResponse['booking']['reference'];
					return view('admin/booking/download_hotel')->with(['header' => $header, 'bookingDetail' => $bookingData, 'bookingNotes' => $bookingNotes]);
				} else {
					return view('admin/booking/download')->with(['header' => $header, 'bookingDetail' => $bookingData]);
				}
			} else {
				return view('admin/booking/view')->with(['header' => $header, 'bookingDetail' => $bookingData]);
			}

        } else {
            return redirect()->route('booking.index')->with('error', $response['message']);
        }
    }

    public function cancelBooking($id) {
        $cancelStatus = '';
        $bookingRef = '';
        $where = [
            [
                'field' => 'id',
                'condition' => '=',
                'value' => $id
            ],
            [
                'field' => 'booking_status',
                'condition' => '=',
                'value' => 'confirmed'
            ]
        ];
        $message = '';
        $bookingDetailsResponse = Bookings::getBooking($where);
        if ($bookingDetailsResponse['status'] == 'true') {
            $bookingDetails = $bookingDetailsResponse['data'][0];
            $bookingRef = $bookingDetails['booking_ref'];
            $bookingSupplierNumber = $bookingDetails['supplier_booking_associated_ref'];
            $message = 'Unable to delete the booking "'.$bookingRef.'". ';
            switch ($bookingDetails['booking_type']) {
                case 'Flight':
                    $data = [
                        'booking_status' => 'cancelled not refunded',
                        'booking_sub_status' => '',
                        'booking_status_message' => 'After booking cancelled by Admin',
                        'booking_cancel_amount' => '',
                        'booking_cancel_at' => Carbon::now(),
                        'service_provider_cancel_response' => ''
                    ];
                    Bookings::updateBooking($id, $data);

                    // $bookingCancellationDetails = $this->flightBookingCancel($bookingSupplierNumber);
                    // if ($bookingCancellationDetails['http_code'] == 204) {
                    //     $cancelStatus = 'CANCELLED';

                    //     $data = [
                    //         'booking_status' => 'cancelled-not-refunded',
                    //         'booking_status_message' => 'After booking cancelled by Admin',
                    //         'booking_cancel_amount' => '',
                    //         'booking_cancel_at' => Carbon::now(),
                    //         'service_provider_cancel_response' => $bookingCancellationDetails['response']
                    //     ];
                    //     Bookings::updateBooking($id, $data);

                    //     $supplierParentLogId = $this->getSupplierLogParentIdForBooking($id);
                    //     if ($supplierParentLogId != '') {
                    //         $this->createSupplierLog('Flight', 'Amadeus', 'flight-cancel-order', '', json_encode($bookingCancellationDetails['response']), $bookingDetails['customer_id']);
                    //     }
                    // } else {
                    //     $message .= $bookingCancellationDetails['message'];
                    // }
                    break;
                case 'Hotel':
                    $bookingCancellationDetails = $this->hotelCancelBooking($bookingSupplierNumber);
                    if ($bookingCancellationDetails['status'] == 'true') {
                        $cancelStatus = $bookingCancellationDetails['data']['status'];
                        $cancelAmount = $bookingCancellationDetails['data']['hotel']['cancellationAmount'];
                        if ($cancelStatus == 'CANCELLED') {
                            $data = [
                                'booking_status' => 'cancelled not refunded',
                                'booking_status_message' => 'After booking cancelled by Admin',
                                'booking_cancel_amount' => $cancelAmount,
                                'booking_cancel_at' => Carbon::now(),
                                'service_provider_cancel_response' => $bookingCancellationDetails['response']
                            ];
                            Bookings::updateBooking($id, $data);

                            $supplierParentLogId = $this->getSupplierLogParentIdForBooking($id);
                            if ($supplierParentLogId != '') {
                                $this->createSupplierLog('Hotel', 'Hotel Beds', 'hotel-cancel-order', '', json_encode($bookingCancellationDetails['response']), $bookingDetails['customer_id']);
                            }
                        }
                    } else {
                        $message .= $bookingCancellationDetails['message'];
                    }
                    break;
            }
        }
        if ($cancelStatus == 'CANCELLED') {
            $response = array(
                'status' => 1,
                'message' => '',
                'data' => []
            );
            $message = 'Booking "'.$bookingRef.'" have cancelled successfully.';
            return redirect()->route('booking.index', $response); //->with('success', $message);
        } else {
            return redirect()->route('booking.index')->with('error', $message);
        }
        die;
    }

    public function refundBooking($id, Request $request) {
        $bookingDetails = Bookings::whereId($id)->first();

        if ($bookingDetails) {
            $bookingDetails = $bookingDetails->toArray();
            $paymentDetails = Payment::where('booking_id', $id)->first()->toArray();
            $paymentId = ($paymentDetails['payment_type'] == 'DB') ? $paymentDetails['debit_id'] : $paymentDetails['capture_id'];
            $processedCancelAmount = $request->input('amount');
            $paymentBrand = $paymentDetails['payment_brand'];
            $currency = $bookingDetails['customer_currency'];

            $refundResponse = $this->refundPayment($paymentId, $paymentBrand, $processedCancelAmount, $currency);
            $updatePaymentPayload = [
                'booking_cancel_amount' => $bookingDetails['booking_cancel_amount'],
                'refund_amount' => $processedCancelAmount,
                'refund_status' => ($refundResponse['status'] == 'true') ? 'success' : 'failure',
                'refund_response' => $refundResponse['data'],
                'refund_at' => Carbon::now(),
            ];
            Payment::updatePayment($paymentDetails['id'], $updatePaymentPayload);

            if ($refundResponse['status'] == 'true') {
                $updateBookingPayload = [
                    'booking_status' => 'cancelled and refunded',
                    'booking_sub_status' => 'Refunded',
                    'booking_status_message' => $processedCancelAmount.' '.$currency.' have refunded successfully.',
                    'processed_cancel_amount' => $processedCancelAmount
                ];
                Bookings::updateBooking($id, $updateBookingPayload);

                $response = array(
                    'status' => 1,
                    'message' => '',
                    'data' => []
                );
                $message = 'Booking "'.$bookingDetails['booking_ref'].'" have refunded successfully.';
                return redirect()->route('booking.index', $response); //->with('success', $message);
            } else {
                return redirect()->route('booking.index')->with('error', 'Unable to refund.');
            }
        } else {
            return redirect()->route('booking.index')->with('error', 'Unable to find the booking.');
        }
        die;
    }

    public function supplierLog($id) {
        $bookingLogs = $this->getSupplierLogForBooking($id);
        if (count($bookingLogs) > 0) {
            $supplierReference = '';
            $jsonFiles = [];
            $logDirectory = 'public';
            $logFileNamePrefix = 'log';
            foreach ($bookingLogs as $bookingLog) {
                if ($supplierReference == '' && $bookingLog['supplier_reference'] != '') {
                    $supplierReference = $bookingLog['supplier'].'-'.$bookingLog['supplier_reference'];
                }
                if ($bookingLog['request'] != '') {
                    $fileName = $bookingLog['log_type'].'-request.json';
                    Storage::disk($logDirectory)->put($fileName, $bookingLog['request']);
                    array_push($jsonFiles, $fileName);
                }
                if ($bookingLog['response'] != '') {
                    $fileName = $bookingLog['log_type'].'-response.json';
                    Storage::disk($logDirectory)->put($fileName, $bookingLog['response']);
                    array_push($jsonFiles, $fileName);
                }
            }
            $bookingDetails = Bookings::select('booking_status', 'service_provider_cancel_response')
                                ->whereId($id)
                                ->first();
            if ($bookingDetails) {
                $bookingDetails = $bookingDetails->toArray();
                if ($bookingDetails['booking_status'] == 'cancelled') {
                    $fileName = 'hotel-order-cancellation-response.json';
                    Storage::disk($logDirectory)->put($fileName, $bookingDetails['service_provider_cancel_response']);
                    array_push($jsonFiles, $fileName);
                }
            }
            if ($supplierReference != '') {
                $logFileNamePrefix = $supplierReference;
            }
            if (count($jsonFiles) > 0) {
                $zip = new \ZipArchive();
                $logFileName = $logFileNamePrefix.'.zip';
                if ($zip->open(public_path($logFileName), \ZipArchive::CREATE)== TRUE) {
                    foreach ($jsonFiles as $jsonFile) {
                        $zip->addFile(public_path("storage/".$jsonFile), $jsonFile);
                    }
                }
                $zip->close();
                foreach ($jsonFiles as $jsonFile) {
                    @unlink(public_path("storage/".$jsonFile));
                }
                return response()->download(public_path($logFileName));
            }

        }
    }

    public function download($id)
    {

        $header['title'] = "View Booking";
        $header['heading'] = "View Booking";

        $filter = array(
            'id' => $id
        );

        //echo "<pre>";print_r($filter);die;
        $bookingListData = Bookings::getBookings($filter);
        $bookingDataCount = Bookings::count();
        $bookingData = $bookingListData['data'];

        $supplierDataList = Suppliers::get()->toArray();
        $getServiceType = ServiceType::get()->toArray();
        $getAgency = Agency::get()->toArray();
        $activityLog['request'] =  request()->input();
        $activityLog['request_url'] =  request()->url();
        $activityLog['response'] =  $bookingData;
       // ActiveLog::createBackendActiveLog($activityLog);

		$bookingNotes = "";
        if (!empty($bookingData)) {
			if($bookingData->booking_type == "Hotel") {

                $supplierResponse = json_decode($bookingData->service_provider_response, true);
				//echo "<pre>";
				//print_r($supplierResponse);die;
                $bookingNotes = 'Payable through '.$supplierResponse['booking']['hotel']['supplier']['name'].', acting as agent for the service operating company, details of which can be provided upon request. VAT: '.$supplierResponse['booking']['hotel']['supplier']['vatNumber'].' Reference: '.$supplierResponse['booking']['reference'];
                return view('admin/booking/download_hotel')->with(['header' => $header, 'bookingDetail' => $bookingData, 'bookingNotes' => $bookingNotes]);
			} else {
                return view('admin/booking/download')->with(['header' => $header, 'bookingDetail' => $bookingData]);
			}
        } else {
            return redirect()->route('booking.index')->with('error', '');
        }
    }

    public function downloadTicket($id)
    {
        $baseUrl = url('/');
        $filename = "ticket_pdf/".rand().".pdf";
		$url = $baseUrl."/booking/download/".$id;
		
        $where = [
            [
                'field' => 'id',
                'condition' => '=',
                'value' => $id
            ]
        ];
        $message = '';
        $bookingDetailsResponse = Bookings::getBooking($where);

        if ($bookingDetailsResponse['status'] == 'true') {
            $bookingDetails = $bookingDetailsResponse['data'][0];
            $filename = $bookingDetails['booking_ref'].".pdf";
        }

		// $filename = rand().".pdf";
		$pdf_file_url = $_SERVER["DOCUMENT_ROOT"]."/".$filename;
		$cmd = "wkhtmltopdf $url $pdf_file_url 2>&1";

		exec($cmd);
		$file = $baseUrl."/".$filename;
		header("Content-type: application/pdf");
		header("Content-Disposition: inline; filename=".$file);
		readfile($file);
		die;
		//$file = 'ticket_pdf/' . $propsId . '.pdf';

		//die;
		//$result = file_get_contents("https://demo.mafhumalqima.com/cron/generatePDF?apikey=" . urlencode($apikey) . "&url=" . urlencode($url));
		$ch = curl_init();

		curl_setopt($ch, CURLOPT_HEADER, 0);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_URL, $Endurl);
		curl_setopt($ch, CURLOPT_POSTFIELDS,
            "url=".$url);
		$data = curl_exec($ch);
		curl_close($ch);
		$file = "mypdf-1.pdf";
		file_put_contents('mypdf-1.pdf', $data);
        header("Content-type: application/pdf");
        header("Content-Disposition: inline; filename=".$file);
        readfile($file);
		die;
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function test($id, Request $request) {
        $bookingDetails = Bookings::where('booking_ref', $id)->first();
        $this->sendBookingEmail2($bookingDetails);
    }
}
