<?php

/**
 * @package     Markups
 * @subpackage   Markups
 * @Author      Amar Technolabs Pvt. ltd(info@amarinfotech.com)
 * @Copyright(C) 2023 [Travel Portal].
 * @Version 1.0.0
 * module of the  Markups.
 */

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Carbon;
use App\Models\Setting;
use App\Models\Suppliers;
use App\Models\ServiceType;
use App\Models\Airport;
use App\Models\Airline;
use App\Models\Markups;
use DB;

class MarkupsController extends Controller
{
    /**
     * Display a listing of the markups.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $header['title']="Markups List";
        $header['heading']="Markups List";
        $appliedFilter = "";
        return view('admin/markups/index')->with(['header'=>$header,'appliedFilter'=>$appliedFilter]);
    }


    /**
     * Show the form for creating a new markups.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $header['title'] = "Flight - Add";
        $header['heading'] = "Flight - Add";
        
        return view('admin/markups/add')->with(['header' => $header]);;
    }

    /**
     * Store a newly created markups in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $requestData = $request->only(['service_type_id',
            'channel',
            'supplier',
            'origin',
            'destination',
            'airlines',
            'fromBookingDate',
            'toBookingDate',
            'fromTravelDate',
            'toTravelDate',
            'bookingClass',
            'cabinClass',
            'tripType',
            'paxType',
            'fromBaseFare',
            'toBaseFare',
            'fareType',
            'b2c_markup_type',
            'b2c_markup',
            'b2b_markup_type',
            'b2b_markup',
            'commMarkupOn',
            'priority'
        ]);

        $rules = [
            'channel' => 'required',
            'supplier' => 'required',
            'origin' => 'required',
            'destination' => 'required',
            'airlines' => 'required',
            'fromBookingDate' => 'required',
            'toBookingDate' => 'required',
            'fromTravelDate' => 'required',
            'toTravelDate' => 'required',
            'bookingClass' => 'required',
            'cabinClass' => 'required',
            'tripType' => 'required',
            'paxType' => 'required',
            'fromBaseFare' => 'required',
            'toBaseFare' => 'required',
            'fareType' => 'required',
            'b2c_markup_type' => 'required',
            'b2c_markup' => 'required',
            'b2b_markup_type' => 'required',
            'b2b_markup' => 'required',
            'commMarkupOn' => 'required',
            'priority' => 'required'
        ];

        $customMessages = [];

        $niceNames = array();

        $this->validate($request, $rules, $customMessages, $niceNames);

        $response = Markups::createMarkups($requestData);
        $service_type_id = $response['data']['service_type_id'];
        $getServiceTypeData = ServiceType::select('id','name')->where('id',$service_type_id)->first();
        $serviceTypeName = $getServiceTypeData->name ?? '';
        if ($response['status'] == 1 && !empty($response['data'])) {
            return redirect()->to('markups/manage?service_type='.$serviceTypeName)->with('success', $response['message']);
        } else {
            return redirect()->to('markups/manage?service_type='.$serviceTypeName)->with('error', $response['message']);

        }
    }

    /**
     * Display the specified markups.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Request $request, $id)
    {
        $header['title'] = "Flight - View";
        $header['heading'] = "Flight - View";

        $checkServiceType = ServiceType::where('name',$request->service_type)->first();
        $service_type_id = $checkServiceType->id ?? '';

        $filter = array(
            'id' => $id,
            'service_type_id' => $service_type_id,
        );
        
        $response = Markups::getMarkupsData($filter);
        $markupsDetail = $response['data'];
        $service_type = $markupsDetail['getServiceType']['name'] ?? '';
        if ($response['status'] == 1 && !empty($response['data'])) {
            return view('admin/markups/view')->with(['header' => $header,'service_type'=>$service_type,'markupsDetail'=>$markupsDetail]);
        } else {
            return redirect()->to('markups/manage?service_type='.$service_type)->with('error', $response['message']);
        }
    }

    /**
     * Show the form for editing the specified markups.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(Request $request, $id)
    {
        $header['title'] = "Flight - Edit";
        $header['heading'] = "Flight - Edit";

        $checkServiceType = ServiceType::where('name',$request->service_type)->first();
        $service_type_id = $checkServiceType->id ?? '';

        $filter = array(
            'id' => $id,
            'service_type_id' => $service_type_id,
        );
        
        $response = Markups::getMarkupsData($filter);
        $markupsDetail = $response['data'];

        $service_type = $request->service_type;
        $getServiceTypeData = ServiceType::select('id')->where('name',$service_type)->first();
        $serviceTypeId = $getServiceTypeData->id ?? '';
        $getAirports = Airport::with('airportName')->where('status','active')->get()->toArray();
        $getAirlines = Airline::with('airlineCodeName')->where('status','active')->get()->toArray();
        $serviceType = ServiceType::where('name', 'Flight')->value('id');
        $getSupplier = Suppliers::where('core_service_type_id',$serviceType)->get()->toArray();

        if ($response['status'] == 1 && !empty($response['data'])) {
            return view('admin/markups/editFlight')->with(['header' => $header,'serviceTypeId' => $serviceTypeId,'service_type'=>$service_type,'markupsDetail'=>$markupsDetail,'getAirports'=>$getAirports,'getAirlines'=>$getAirlines,'getSupplier'=>$getSupplier]);
        } else {
            return redirect()->to('markups/manage?service_type='.$service_type)->with('error', $response['message']);
        }
    }

    /**
     * Update the specified markups in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function updateMarkupData(Request $request, $id)
    {
        $requestData = $request->only([
            'markups_id',
            'service_type_id',
            'channel',
            'supplier',
            'origin',
            'destination',
            'airlines',
            'fromBookingDate',
            'toBookingDate',
            'fromTravelDate',
            'toTravelDate',
            'bookingClass',
            'cabinClass',
            'tripType',
            'paxType',
            'fromBaseFare',
            'toBaseFare',
            'fareType',
            'b2c_markup_type',
            'b2c_markup',
            'b2b_markup_type',
            'b2b_markup',
            'commMarkupOn',
            'priority'
        ]);

        $rules = [];

        $customMessages = [];

        $niceNames = array();

        $this->validate($request, $rules, $customMessages, $niceNames);
        $response = Markups::updateMarkups($requestData);
         
        $service_type_id = $response['data']['service_type_id'];
        $getServiceTypeData = ServiceType::select('id','name')->where('id',$service_type_id)->first();
        $serviceTypeName = $getServiceTypeData->name ?? '';
        if ($response['status'] == 1 &&  !empty($response['data'])) {
            return redirect()->to('markups/manage?service_type='.$serviceTypeName)->with('success', $response['message']);
        } else {
            return redirect()->to('markups/manage?service_type='.$serviceTypeName)->with('error', $response['message']);

        }
    }

    /**
     * Remove the specified markups from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

     /**
     * Display a listing of the markups.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function getListData(Request $request){    
        if(isset($_GET['service_type'])){
            $serviceTypes = str_replace(' ', '_',$_GET['service_type']);
        }

        $header['title']="Markups List";
        $header['heading']="Markups List";
        $queryStringConcat = '?';
        if (isset($_GET['per_page'])) {
            $queryStringConcat .= ($queryStringConcat == '') ? '?per_page=' . $_GET['per_page'] : '&per_page=' . $_GET['per_page'];
        }
        if (isset($_GET['page'])) {
            $queryStringConcat .= ($queryStringConcat == '') ? '?page=' . $_GET['page'] : '&page=' . $_GET['page'];
        }

        $appliedFilter = array(
            'per_page' => (request()->input('per_page') != NULL) ? request()->input('per_page') : Setting::where('config_key', 'general|setting|pagePerAdminRecords')->get('value')[0]['value'],
            'order_by' => (request()->input('order_by') != NULL) ? request()->input('order_by') : 'created_at',
            'sorting' => (request()->input('sorting') != NULL) ? request()->input('sorting') : 'desc',
            'origin' => (request()->input('origin') != NULL) ? request()->input('origin') : '',
            'destination' => (request()->input('destination') != NULL) ? request()->input('destination') : '',
            'service_type' => $_GET['service_type'] ?? '',
        );

        if (request()->input('origin') != NULL) {
            $appliedFilter['where'][] = ['origin', '=', request()->input('origin')];
        }

        if (request()->input('destination') != NULL) {
            $appliedFilter['where'][] = ['destination', '=', request()->input('destination')];
        }

        $markupsDataList = Markups::getMarkupsData($appliedFilter);
        $markupsDataCount = Markups::count();
        $markupsData = $markupsDataList['data'];
        if ($markupsData['status'] == 1) {
            return view('admin/markups/index')->with(['header'=>$header,'appliedFilter'=>$appliedFilter,'serviceType'=>$serviceTypes,'markupsDataCount'=>$markupsDataCount,'markupsData'=>$markupsData,'queryStringConcat' => $queryStringConcat, 'i' => (request()->input('page', 1) - 1) * $appliedFilter['per_page']]);
        } else { 
            return view('admin/markups/index')->with(['header'=>$header,'appliedFilter'=>$appliedFilter,'serviceType'=>$serviceTypes,'markupsData'=>$markupsData,'markupsDataCount'=>$markupsDataCount,'queryStringConcat' => $queryStringConcat, 'i' => (request()->input('page', 1) - 1) * $appliedFilter['per_page']]);
        }
    }

    /**
     * Fetch airport for origin.
     *
     * 
     * @return \Illuminate\Http\Response
     */
    public function fetchOriginList(Request $request)
    {
       
        $requestData = $request->all();
        $term = $request->input('term');
        $page = $request->input('page');
        $resultsPerPage = 10;
        $offset = ($page - 1) * $resultsPerPage;

        $query = Airport::with('airportName');

        if ($term) {
            $query->whereHas('airportName', function ($query) use ($term) {
                $query->where('airport_name', 'like', '%' . $term . '%');
            });
        }
        $query->offset($offset)->limit($resultsPerPage);
        $query->orderBy('iata_code', 'asc');
        $airports = $query->get();

        $data = [];
        foreach ($airports as $airport) {
            $airname = [];
            if (!empty($airport['airportName'])) {
                foreach ($airport['airportName'] as $airport_name) {
                    $airname[] = $airport_name['airport_name'] . ' ';
                }
            }
            $data[] = ['id' => $airport['id'], 'airname' => $airname];
        }

        return response()->json($data); 
    }

     /**
     * Fetch airline code.
     *
     * 
     * @return \Illuminate\Http\Response
     */
    public function fetchAirlines(Request $request)
    {
        $term = $request->input('term');
        $page = $request->input('page');

        $resultsPerPage = 10;
        $offset = ($page - 1) * $resultsPerPage;
        $query = Airline::with('airlineCodeName');

        if ($term) {
            $query->whereHas('airlineCodeName', function ($query) use ($term) {
                $query->where('airline_name', 'like', '%' . $term . '%');
            });
        }
        $query->offset($offset)->limit($resultsPerPage);
        $query->orderBy('airline_code', 'asc');
        $airlines = $query->get();

        $data = [];
        foreach ($airlines as $airline) {
            $airname = [];
            if (!empty($airline['airlineCodeName'])) {
                foreach ($airline['airlineCodeName'] as $airline_name) {
                    $airname[] = $airline_name['airline_name'] . ' ';
                }
            }
            $data[] = ['id' => $airline['id'], 'airname' => $airname];
        }

        return response()->json($data);
    }

     /**
     * Fetch supplier code.
     *
     * 
     * @return \Illuminate\Http\Response
     */
    public function fetchSupplier(Request $request)
    {
        $requestData = $request->all();
        $page = $request->input('page');
        $resultsPerPage = 10;
        $offset = ($page - 1) * $resultsPerPage;
        $serviceType = ServiceType::where('name','Flight')->get('id')[0]['id'];
        $getSupplier = Suppliers::where('core_service_type_id',$serviceType);
        $getSupplier->offset($offset) // For par page 10 records
                    ->limit($resultsPerPage);
            if($request->input('q') != "") {
                $getSupplier->where('name', 'LIKE', '%' . $request->input('q') . '%');
            }

        $data = $getSupplier->get()->toArray();
        return response()->json($data);
    }

     /**
     *  Store a newly created markups in storage.
     *
     * 
     * @return \Illuminate\Http\Response
     */
    public function addData(Request $request){

        $header['title'] = "Flight - Add";
        $header['heading'] = "Flight - Add";

        $service_type = $request->service_type;
        $getServiceTypeData = ServiceType::select('id')->where('name',$service_type)->first();
        $serviceTypeId = $getServiceTypeData->id ?? '';
        
        return view('admin/markups/add')->with(['header' => $header,'serviceTypeId' => $serviceTypeId]);
    }

    /**
     * Remove the specified markups from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function deleteMarkups(Request $request)
    {
        if(!hasPermission('Markups','delete')){
            return view('admin/401');
        }
        $url = URL::previous();
        $markupsIDs = explode(',', $request->input('delete_markups_id'));

        $message = "";
        foreach ($markupsIDs as $delete_markups_id) {
            $response = Markups::deleteMarkups($delete_markups_id);
            $message .= $response['message'] . '</br>';
        }

        if ($response['status'] == 1) {
            return redirect()->to($url)->with('success', $message);
        } else {
            return redirect()->to($url)->with('error', $response['message']);
        }
    }

}

