<?php

namespace App\Http\Controllers\Admin\Markups;

use App\Enums\ServiceType;
use Illuminate\Http\Request;
use App\Models\SalesServiceMarkup;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class FlightSalesMarkupsController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $flightSalesMarkups = SalesServiceMarkup::getSalesMarkupList(ServiceType::Flight->value);
        $hotelSalesMarkups = SalesServiceMarkup::getSalesMarkupList(ServiceType::Hotel->value);
        return view('admin.markups.sales.index', compact('flightSalesMarkups', 'hotelSalesMarkups'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        
        return view('admin.markups.sales.flight.add');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {

        $request->validate([
            'service_type'        => 'required|in:international,domestic,both',
            'flight_cabin_class'  => 'required|in:economy,premium_economy,business,first_class',
            'markup_percentage'   => 'required|numeric|min:0|max:100',
            'fixed_service_fee'   => 'required|numeric|min:0',
            'sales_service_type'  => 'required|in:cancellation,change_amend,both',
            'status'              => 'required|in:active,inactive',
        ]);

        $data = [
            'service_name' => ServiceType::Flight->value,
            'service_type' => $request->input('service_type'),
            'cabin_class' => $request->input('flight_cabin_class'),
            'markup_percentage' => $request->input('markup_percentage'),
            'fixed_service_fee' => $request->input('fixed_service_fee'),
            'sales_service_type' => $request->input('sales_service_type'),
            'status' =>  $request->input('status', 'active'),
            'created_by' =>  Auth::id(),
        ];

        SalesServiceMarkup::create($data);

        return redirect()->route('flight-sales-markups.index')->with('success', 'Flight Sales Service Fee created successfully.');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        $flightSalesMarkups = SalesServiceMarkup::where('service_name', ServiceType::Flight->value)
            ->where('sales_service_type', 'sales')
            ->orderBy('created_at', 'desc')
            ->get();
        return view('admin.markups.sales.index', compact('flightSalesMarkups'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        $flightSalesMarkup = SalesServiceMarkup::findOrFail($id);
        return view('admin.markups.sales.flight.edit', compact('flightSalesMarkup'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        $request->validate([
            'service_type'        => 'required|in:international,domestic,both',
            'flight_cabin_class'  => 'required|in:economy,premium_economy,business,first_class',
            'markup_percentage'   => 'required|numeric|min:0|max:100',
            'fixed_service_fee'   => 'required|numeric|min:0',
            'sales_service_type'  => 'required|in:cancellation,change_amend,both',
            'status'              => 'required|in:active,inactive',
        ]);


        $salesMarkup = SalesServiceMarkup::findOrFail($id);

        $salesMarkup->update([
            'service_type' => $request->input('service_type'),
            'cabin_class' => $request->input('flight_cabin_class'),
            'markup_percentage' => $request->input('markup_percentage'),
            'fixed_service_fee' => $request->input('fixed_service_fee'),
            'sales_service_type' => $request->input('sales_service_type'),
            'status' =>  $request->input('status', $salesMarkup->status),
        ]);

        return redirect()->route('flight-sales-markups.index')->with('success', 'Flight Sales Service Fee updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        
    }
    public function deleteflightSalesMarkup(string $id)
    {
        $salesMarkup = SalesServiceMarkup::findOrFail($id);
        $salesMarkup->delete();

        return redirect()->route('flight-sales-markups.index')->with('success', 'Flight Sales Service Fee deleted successfully.');
    }
}
