<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Models\HotelSpecialRequest;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class HotelSpecialRequestController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $hotelSpecialRequestList = HotelSpecialRequest::getSpecialRequestList();
        return view('admin.hotel-special-request.index', compact('hotelSpecialRequestList'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'special_request_name' => ['required', 'regex:/^[A-Za-z\s]+$/'],
            'special_request_name_ar' => ['required', 'regex:/^[\p{Arabic}\s]+$/u'],
            'status' => 'required|in:1,0'
        ], [
            'special_request_name.regex' => 'The name must only contain English letters and spaces.',
            'special_request_name_ar.regex' => 'The Arabic name must only contain Arabic letters and spaces.'
        ]);

        $isExist = HotelSpecialRequest::whereRaw('LOWER(special_request_name) = ?', [strtolower($request->special_request_name)])
            ->whereNull('deleted_at')
            ->exists();

        if ($isExist) {
            return redirect()->route('hotel-special-request.index')->with('error', 'Hotel Special Request Name Already Exists');
        }
        try {
            HotelSpecialRequest::create([
                'special_request_name' => $request->special_request_name,
                'special_request_name_ar' => $request->special_request_name_ar,
                'status' => $request->status,
                'created_by' => Auth::id(),
            ]);
            return redirect()->route('hotel-special-request.index')->with('success', 'New Hotel Special Request added successfully');
        } catch (\Exception $e) {
            return redirect()->route('hotel-special-request.index')->with('error', 'An error occurred while saving the request.');
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id) {}

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        $request->validate([
            'special_request_name' => ['required', 'regex:/^[A-Za-z\s]+$/'],
            'special_request_name_ar' => ['required', 'regex:/^[\p{Arabic}\s]+$/u'],
            'status' => 'required|in:1,0'
        ], [
            'special_request_name.regex' => 'The English Special Request name must only contain English letters and spaces.',
            'special_request_name_ar.regex' => 'The Arabic Special Request name must only contain Arabic letters and spaces.'
        ]);


        $specialRequest = HotelSpecialRequest::findOrFail($id);
        $isExist = HotelSpecialRequest::where('special_request_name', $request->special_request_name)
            ->whereNull('deleted_at')
            ->where('id', '!=', $id)
            ->exists();

        if ($isExist) {
            return redirect()->route('hotel-special-request.index')->with('error', 'Hotel Special Request Name Already Exists');
        }

        // Update the record
        $specialRequest->special_request_name = $request->special_request_name;
        $specialRequest->special_request_name_ar = $request->special_request_name_ar;
        $specialRequest->status = $request->status;
        $specialRequest->save();

        return redirect()->route('hotel-special-request.index')->with('success', 'Hotel Special Request updated successfully');
    }


    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }

    public function deleteHotelSpecialRequest(string $id)
    {
        $specialRequest = HotelSpecialRequest::findOrFail($id);
        $specialRequest->delete();

        return redirect()->route('hotel-special-request.index')->with('success', 'Selected Special Request deleted successfully.');
    }
}
