<?php


/**
 * @package     Dashboard
 * @subpackage   Feature Hotels
 * @Author      Amar Technolabs Pvt. ltd(info@amarinfotech.com)
 * @Copyright(C) 2023 [Travel Portal].
 * @Version 1.0.0
 * module of the  Dashboard.
 */

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\URL;
use Intervention\Image\ImageManagerStatic as Image;
use Illuminate\Validation\Rule;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\DB;
use App\Models\Setting;
use App\Models\FeatureHotel;
use App\Traits\EmailService;
use Carbon\Carbon;

class FeatureHotelController extends Controller
{
    use EmailService;
    /**
     * Display a listing of the Feature Hotels.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $header['title'] = "Feature Hotels";
        $header['heading'] = "Feature Hotels";
        $queryStringConcat = '?';
        if (isset($_GET['per_page'])) {
            $queryStringConcat .= ($queryStringConcat == '') ? '?per_page=' . $_GET['per_page'] : '&per_page=' . $_GET['per_page'];
        }
        if (isset($_GET['page'])) {
            $queryStringConcat .= ($queryStringConcat == '') ? '?page=' . $_GET['page'] : '&page=' . $_GET['page'];
        }

        $filter = array(
            'per_page' => (request()->input('per_page') != NULL) ? request()->input('per_page') : Setting::where('config_key', 'general|setting|pagePerAdminRecords')->get('value')[0]['value'],
            'order_by' => (request()->input('order_by') != NULL) ? request()->input('order_by') : 'created_at',
            'sorting' => (request()->input('sorting') != NULL) ? request()->input('sorting') : 'desc',
            'status' => (request()->input('status') != NULL) ? request()->input('status') : '',
        );
        if (request()->input('offer_title') != NULL) {
            $offerTitle = request()->input('offer_title');
            $filter['where'][] = [
                DB::raw("offer_title"),
                'LIKE',
                '%' . $offerTitle . '%'
            ];
        }
        if (request()->input('status') != NULL) {
            $filter['where'][] = ['status', '=', request()->input('status')];
        }
        $featureHotelsDataList = FeatureHotel::getFeatureHotels($filter);
        $featureHotelsData = $featureHotelsDataList['data'];
        if ($featureHotelsData['status'] == 1) {
            return view('admin/feature-hotel/index')->with(['header' => $header, 'featureHotelsData' => $featureHotelsData, 'queryStringConcat' => $queryStringConcat, 'appliedFilter' => $filter,  'i' => (request()->input('page', 1) - 1) * $filter['per_page']]);
        } else {
            return view('admin/feature-hotel/index')->with(['header' => $header, 'featureHotelsData' => $featureHotelsData, 'queryStringConcat' => $queryStringConcat, 'appliedFilter' => $filter, 'i' => (request()->input('page', 1) - 1) * $filter['per_page']]);
        }
    }

    /**
     * Show the form for creating a new feature hotel
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {
        if (!hasPermission('CUSTOMERS_LIST', 'create')) {
            return view('admin/401');
        }
        $featureHotelId = $request->id;
        $header['title'] = 'Add Feature Hotel';

        return view('admin/feature-hotel/add')->with(['header' => $header]);
    }

    /**
     * Store a newly created feature hotels in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $requestData = $request->all();
        $response = FeatureHotel::createFeatureHotel($requestData);
        if (!empty($response['data'])) {
            return redirect()->route('feature-hotel.index', $response)->with('success', $response['message']);
        } else {
            return redirect()->back()->with('error', $response['message']);
        }
    }

    /**
     * Display the specified feature hotel.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        if (!hasPermission('TRAVELLER_LIST', 'read')) {
            return view('admin/401');
        }
        $header['title'] = @trans('travellers.viewTravellers');
        $header['heading'] = @trans('customers.moduleHeading');
        $filter = array(
            'id' => $id
        );
        $response = FeatureHotel::getFeatureHotels($filter);
        $featureHotelDetails = $response['data'];
        if ($response['status'] == 1 && !empty($response['data'])) {
            return view('admin/feature-hotel/view')->with(['header' => $header, 'featureHotelDetails' => $featureHotelDetails]);
        } else {
            return redirect()->route('feature-hotel.index')->with('error', $response['message']);
        }
    }

    /**
     * Show the form for editing the specified feature hotel.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        if (!hasPermission('CUSTOMERS_LIST', 'update')) {
            return view('admin/401');
        }
        $header['title'] = 'Edit Feature Hotel';
        $header['heading'] = @trans('customers.moduleHeading');
        $header['method'] = 'Edit';

        $filter = array(
            'id' => $id
        );
        $response = FeatureHotel::getFeatureHotels($filter);
        $featureHotelDetails = $response['data'];
        if ($response['status'] == 1 && !empty($response['data'])) {
            return view('admin/feature-hotel/update')->with(['header' => $header, 'featureHotelDetails' => $featureHotelDetails]);
        } else {
            return redirect()->route('feature-hotel.index')->with('error', $response['message']);
        }
    }

    /**
     * Update the specified feature hotel in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $url = $request->redirects_to;
        $requestData = $request->all();

        $rules = [];
        $customMessages = [];

        $niceNames = array();

        $this->validate($request, $rules, $customMessages, $niceNames);

        $response = FeatureHotel::updateFeatureHotel($requestData);

        if (!empty($response['data'])) {
            return redirect()->route('feature-hotel.index', compact('id'))->with('success', $response['message']);
        } else {
            return redirect()->to($url)->with('error', $response['message']);
        }
    }

    /**
     * Remove the specified feature hotel from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function deleteFeatureHotel($featureHotelID)
    {
        $url = URL::previous();
        $response = FeatureHotel::deleteFeatureHotel($featureHotelID);
        $message = $response['message'] . '</br>';

        if ($response['status'] == 1) {
            return redirect()->to($url)->with('success', $message);
        } else {
            return redirect()->to($url)->with('error', $response['message']);
        }
    }
}
