<?php

namespace App\Http\Controllers\Admin;

use ZipArchive;
use Carbon\Carbon;
use App\Models\Page;
use App\Enums\Locale;
use App\Models\Agency;
use App\Models\Payment;
use App\Models\Setting;
use App\Models\Bookings;
use App\Traits\Gimmonix;
use App\Models\PageI18ns;
use App\Models\Suppliers;
use App\Traits\ActiveLog;
use App\Traits\HotelBeds;
use Illuminate\Http\File;
use App\Models\BookingLog;
use App\Traits\SmsService;
use App\Models\ServiceType;
use App\Enums\BookingStatus;
use App\Enums\PaymentStatus;
use App\Enums\ServiceType as EnumsServiceType;
use App\Models\CountryI18ns;
use App\Traits\EmailService;
use Illuminate\Http\Request;
use App\Traits\CommonService;
use App\Traits\TraacsService;
use App\Models\BookingHistory;
use App\Models\InvoiceSetting;
use App\Traits\AmadeusService;
use App\Traits\BookingService;
use App\Traits\PaymentService;
use App\Models\BookingCheckout;
use App\Models\EditHotelDetail;
use App\Models\BookingStatusLog;
use App\Models\EditFlightDetail;
use App\Models\CustomerAddresses;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\URL;
use App\Http\Controllers\Controller;
use App\Models\Airline;
use App\Models\AirlineI18ns;
use Illuminate\Support\Facades\Auth;
use function PHPUnit\Framework\isNull;
use App\Models\BookingAdditionalDetail;
use App\Models\CityI18n;
use Illuminate\Support\Facades\Storage;
use Yajra\DataTables\Facades\DataTables;
use App\Services\TranslateBookingDetails;
use Barryvdh\DomPDF\Facade\Pdf as FacadePdf;

class BookingController extends Controller
{
    use AmadeusService, BookingService, CommonService, EmailService, HotelBeds, Gimmonix, SmsService, ActiveLog, PaymentService, TraacsService;

    public function __construct()
    {
        $this->perPage = count(Setting::where('config_key', 'general|setting|pagePerAPIRecords')->get('value')) > 0 ? Setting::where('config_key', 'general|setting|pagePerAPIRecords')->get('value')[0]['value'] : "20";

        //set AMADEUS API configuration from config key
        $this->amadeusAPIEnvironment = env('AMADEUS_API_CREDENTIALS');

        if ($this->amadeusAPIEnvironment == 'test') {
            $this->amadeusAPIEndPoint = env('AMADEUS_API_TEST_API_ENDPOINT');
            $this->amadeusAPIClientID = env('AMADEUS_API_TEST_CLIENT_ID');
            $this->amadeusAPIClientSecret = env('AMADEUS_API_TEST_CLIENT_SECRET');
            $this->amadeusAPIGrantType = env('AMADEUS_API_TEST_GRANT_TYPE');
        } else {
            $this->amadeusAPIEndPoint = env('AMADEUS_API_LIVE_API_ENDPOINT');
            $this->amadeusAPIClientID = env('AMADEUS_API_LIVE_CLIENT_ID');
            $this->amadeusAPIClientSecret = env('AMADEUS_API_LIVE_CLIENT_SECRET');
            $this->amadeusAPIGrantType = env('AMADEUS_API_LIVE_GRANT_TYPE');
        }

        $this->amadeusAPISecret = env('AMADEUS_API_SECRET');
    }

    public function index(Request $request)
    {
        // $results = Bookings::get();
        // $dataList = array();
        // foreach($results as $result)
        // {
        //     $dataList[] = array('id'=>$result->id, 'sub_total' => $result->sub_total);
        // }
        //print_r($dataList);
        //exit;
        $supplierDataList = Suppliers::get()->toArray();

        $suppliers = [];
        if ($supplierDataList) {
            foreach ($supplierDataList as $value) {
                $suppliers[$value['id']] = $value['name'];
            }
        }
        if ($request->ajax()) {


            // dd(request->get('booking_date'));

            $i = 0;
            //$results = Bookings::latest()->get();//->orderBy('created_at', 'DESC')
            $results = Bookings::with('bookingCheckout')->select('*')->orderBy('created_at', 'DESC');
            return DataTables::of($results)
                ->addIndexColumn()
                ->filter(function ($instance) use ($request) {
                    if ($request->get('booking_date')) {
                        $instance->where('booking_date', date("Y-m-d", strtotime($request->get('booking_date'))));
                    }
                    if ($request->get('supplier_id')) {
                        $instance->where('supplier_id', $request->get('supplier_id'));
                    }
                    if ($request->get('service_id')) {

                        $instance->where('service_id', $request->get('service_id'));
                    }
                    if ($request->get('booking_type')) {

                        $instance->where('booking_type', ucwords($request->get('booking_type')));
                    }

                    if ($request->get('system_ref_id')) {
                        $system_ref_id = $request->get('system_ref_id');
                        $instance->where('supplier_booking_ref', 'like', '%' . $system_ref_id . '%');
                    }
                    if ($request->get('supplier_booking_associated_ref')) {
                        $system_ref_id = $request->get('supplier_booking_associated_ref');
                        $instance->where('supplier_booking_associated_ref', 'like', '%' . $system_ref_id . '%');
                    }
                    if ($request->get('ticket_numbers')) {
                        $ticket_numbers = $request->get('ticket_numbers');
                        $instance->where('ticket_numbers', 'like', '%' . $ticket_numbers . '%');
                    }
                    if ($request->get('booking_id')) {
                        $booking_ref = $request->get('booking_id');
                        $instance->where('booking_ref', 'like', '%' . $booking_ref . '%');
                    }
                    if ($request->get('price_from')) {
                        $instance->where('total', '>=', $request->get('price_from'));
                    }
                    if ($request->get('price_to')) {
                        $instance->where('total', '<=', $request->get('price_to'));
                    }
                    if ($request->get('pnr_number')) {
                        $pnr_number = $request->get('pnr_number');
                        //$instance->where('pnr_number', 'like', '%' . $pnr_number . '%');
                    }
                    if ($request->get('customer_id')) {
                        $instance->where('customer_id', $request->get('customer_id'));
                    }
                    if ($request->get('booking_status')) {
                        $booking_sub_status = '';
                        if ($request->get('booking_status') == 'supplier_failed') {
                            $booking_sub_status = 'Supplier failed';
                            $instance->where('booking_status', 'failed')->where('booking_sub_status', $booking_sub_status);
                        } else if ($request->get('booking_status') == 'payment_failed') {

                            $booking_sub_status = 'Supplier success and Payment failed';
                            $instance->where('booking_status', 'failed')->where('booking_sub_status', $booking_sub_status);
                        } else {

                            $instance->where('booking_status', $request->get('booking_status'));
                        }
                    }
                    if ($request->get('payment_status')) {
                        //$instance->where('payment_status', $request->get('payment_status'));
                    }
                    if ($request->get('agency_id')) {
                        $instance->where('agency_id', $request->get('agency_id'));
                    }
                    if ($request->get('channel')) {
                        $instance->where('booking_from', $request->get('channel'));
                    }
                    if ($request->get('fromDate') && $request->get('toDate')) {
                        $fromDate = Carbon::parse($request->fromDate)->startOfDay();
                        $toDate = Carbon::parse($request->toDate)->endOfDay();
                        $instance->whereBetween('created_at', [$fromDate, $toDate]);
                    }
                    if ($request->has('search') && ! is_null($request->get('search')['value'])) {
                        $regex = $request->get('search')['value'];
                        $instance->where('booking_ref', 'like', '%' . $regex . '%');
                        $instance->orWhere('supplier_booking_associated_ref', 'like', '%' . $regex . '%');
                        $instance->orWhere('booking_date', 'like', '%' . date('Y-m-d', strtotime($regex)) . '%');
                        $instance->orWhere('email', 'like', '%' . $regex . '%');
                        $instance->orWhere('first_name', 'like', '%' . $regex . '%');
                        $instance->orWhere('ticket_numbers', 'like', '%' . $regex . '%');
                        $instance->orWhere('rehtle_ref', 'like', '%' . $regex . '%');
                        $instance->orWhere('ref_id', 'like', '%' . $regex . '%');
                        $instance->orWhere('supplier_booking_ref', 'like', '%' . $regex . '%');
                        $instance->orWhere('supplier_id', 'like', '%' . $regex . '%');
                        $instance->orWhere('booking_status', 'like', '%' . $regex . '%');
                        $instance->orWhere('service_provider', 'like', '%' . $regex . '%');
                        $instance->orWhere('booking_type', 'like', '%' . $regex . '%');
                    }
                })
                ->addColumn("booking_type", function ($data) {
                    if (empty($data->booking_type)) {
                        return "N/A";
                    }
                    return $data->booking_type;
                })
                ->addColumn("booking_ref", function ($data) {
                    if (empty($data->booking_ref)) {
                        return "N/A";
                    }
                    return '<a href="' . route('booking.edit', $data->id) . '" title="Edit Booking">' . $data->booking_ref . '</a>';
                })
                ->addColumn("supplier_booking_ref", function ($data) {
                    if (empty($data->supplier_booking_ref)) {
                        return "N/A";
                    }
                    return $data->supplier_booking_ref;
                })
                ->addColumn("supplier_booking_associated_ref", function ($data) {
                    if (empty($data->supplier_booking_associated_ref)) {
                        return "N/A";
                    }
                    return $data->supplier_booking_associated_ref;
                })
                ->addColumn("ticket_numbers", function ($data) {
                    if (empty($data->ticket_numbers)) {
                        return "";
                    }
                    return $data->ticket_numbers;
                })
                ->addColumn("supplier_id", function ($data) use ($suppliers) {
                    if (empty($data->supplier_id)) {
                        return "N/A";
                    }
                    return $suppliers[$data->supplier_id];
                })
                ->addColumn("supplier", function ($data) {
                    if ($data->booking_type == 'Flight') {
                        $serviceType = ServiceType::where('name', $data->booking_type)->value('id');
                        $getSupplier = Suppliers::where('core_service_type_id', $serviceType)->first();
                        if (!$getSupplier) {
                            return "N/A";
                        }
                        return $getSupplier->name;
                    } elseif ($data->booking_type == 'Hotel') {
                        // $booking = BookingCheckout::where('booking_id', $data->id)->first();
                        $supplierName = $data->bookingCheckout->supplier_name ?? "N/A";
                        return $supplierName;
                    }
                })
                ->addColumn("total", function ($data) {
                    if (empty($data->total)) {
                        return "N/A";
                    }
                    return $data->total;
                })
                ->addColumn("booking_cancel_amount", function ($data) {
                    if ($data->booking_cancel_amount == '') {
                        return "N/A";
                    }
                    if ($data->booking_cancel_amount != '' && $data->processed_cancel_amount == '' && $data->processed_cancel_amount != '0.00') {
                        $bookingCancelAmount = ($data['booking_status'] == 'cancelled not refunded') ? $data->total : $data->booking_cancel_amount;
                        return $bookingCancelAmount . '<br/><a href="#" class="refund-booking" data-id="' . $data->id . '" data-amount="' . $bookingCancelAmount . '" title="Refund">Refund</a>';
                    }
                    return $data->booking_cancel_amount;
                })
                ->addColumn("processed_cancel_amount", function ($data) {
                    if ($data->processed_cancel_amount == '') {
                        return "N/A";
                    }
                    return $data->processed_cancel_amount;
                })
                ->addColumn("is_guest", function ($data) {
                    return ($data->is_guest == 'true') ? 'Yes' : 'No';
                })
                ->addColumn("email", function ($data) {
                    if (empty($data->email)) {
                        return "N/A";
                    }
                    return $data->email;
                })
                ->addColumn("phone", function ($data) {
                    if (empty($data->phone)) {
                        return "N/A";
                    }
                    return $data->phone_country_code . $data->phone;
                })
                ->addColumn("description", function ($data) {
                    if (empty($data->description)) {
                        return "N/A";
                    }
                    return $data->description;
                })
                ->addColumn("booking_date", function ($data) {
                    if (empty($data->booking_date)) {
                        return "N/A";
                    }
                    return getDateTimeZone($data->booking_date);
                })
                ->addColumn("booking_from", function ($data) {
                    $channel = 'N/A';
                    if ($data->booking_from == 'web') {
                        $channel = 'Desktop';
                    } else if ($data->booking_from == 'b2c_mobile_browser') {
                        $channel = 'Mobile Browser';
                    } else {
                        $channel = 'Mobile App';
                    }
                    return $channel ?? 'N/A';
                })
                ->addColumn("booking_status", function ($data) {
                    if (empty($data->booking_status)) {
                        return "N/A";
                    }
                    $bookingStatusContent = '
                    <div class="booking-status ' . $data->booking_status . '">
                        ' . ucfirst($data['booking_status']);
                    if ($data['booking_status'] != BookingStatus::Confirmed->value && $data->booking_sub_status != '') {
                        $bookingStatusContent .= ': ' . $data->booking_sub_status;
                    }
                    if ($data['booking_status'] != BookingStatus::Confirmed->value  && $data->booking_status_message != '') {
                        $bookingStatusContent .= '<br/><span class="booking-status-message">(' . $data->booking_status_message . ')</span>';
                    }
                    $bookingStatusContent .= '</div>';

                    return $bookingStatusContent;
                })
                ->addColumn("action", function ($data) {
                    $bookingStatusLog = BookingStatusLog::where('booking_id', $data->id)->exists();
                    $styleName = $bookingStatusLog ? '' : 'display:none';

                    $ticketVoucher = $data->booking_type == 'Flight' ? 'booking/download-flight-ticket/' : 'booking/downloadVoucher/';
                    $title = $data->booking_type == 'Flight' ? 'Download Flight Ticket' : 'Download Voucher';

                    $actionContent = '<div class="dropdown">
            <button class="btn btn-sm btn-outline-secondary dropdown-toggle" type="button"      data-bs-toggle="dropdown" aria-expanded="false" title="Actions">
                 <i class="fa fa-ellipsis-v"></i>
             </button>
             <ul class="dropdown-menu">';
                    // Edit Booking
                    $actionContent .= '<li><a class="dropdown-item" href="' . route('booking.edit', $data->id) . '" title="Edit Booking">
                    <i class="fa fa-pen me-1"></i> Edit Booking</a></li>';

                    // Edit Status
                    $actionContent .= '<li><button type="button" class="dropdown-item btn-status-edit" data-id="' . $data->id . '" data-status="' . $data->booking_status . '" data-description="' . $data->booking_status_description . '" title="Edit Status">
                    <i class="fa fa-edit me-1"></i> Edit Status</button></li>';

                    // Download Invoice (En)
                    $actionContent .= '<li><a class="dropdown-item" href="' . route('booking.show', ['id' => $data->id, 'locale' => 'en']) . '" title="Download Invoice (En)">
                    <i class="fa fa-download me-1"></i> Download Invoice (En)</a></li>';

                    // Download Invoice (Ar)
                    $actionContent .= '<li><a class="dropdown-item" href="' . route('booking.show', ['id' => $data->id, 'locale' => 'ar']) . '" title="Download Invoice (Ar)">
                    <i class="fa fa-download me-1"></i> Download Invoice (Ar)</a></li>';


                    // Download Ticket/Voucher
                    $actionContent .= '<li><a class="dropdown-item" href="' . url($ticketVoucher) . '/' . $data->id . '/en' . '" title="' . $title . '">
                    <i class="fa fa-ticket-alt me-1"></i> ' . $title . ' (En)' . '</a></li>';

                    $actionContent .= '<li><a class="dropdown-item" href="' . url($ticketVoucher) . '/' . $data->id . '/ar' . '" title="' . $title . '">
                    <i class="fa fa-ticket-alt me-1"></i> ' . $title . ' (Ar)' . '</a></li>';


                    // Status Log (conditionally visible)
                    if ($bookingStatusLog) {
                        $actionContent .= '<li><a class="dropdown-item log-booking" href="' . route('booking.view-booking-status-log', $data->id) . '" title="View Status Log">
            <i class="fa fa-list-alt me-1"></i> View Status Log</a></li>';
                    }

                    // Optional: Cancel Booking (uncomment if needed)
                    // if ($data->booking_status == BookingStatus::Confirmed->value) {
                    //     $actionContent .= '<li><a href="#" class="dropdown-item cancel-booking" data-id="' . $data->id . '" title="Cancel Booking">
                    //         <i class="fa fa-times-circle me-1"></i> Cancel Booking</a></li>';
                    // }

                    $actionContent .= '</ul></div>';

                    return $actionContent;
                })

                ->rawColumns(["action", "booking_ref", "booking_status", "booking_cancel_amount", "booking_from"])
                ->make(true);
        }
        $data["title"] = "Manage Booking";
        $data['heading'] = "Booking";
        $data['supplierDataList'] = $supplierDataList;
        $data['getServiceType'] = ServiceType::get()->toArray();
        $data['getAgency'] = Agency::get()->toArray();
        return view("admin.booking.index", $data);
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index_old()
    {
        $header['title'] = "Booking";
        $header['heading'] = "Booking";

        $queryStringConcat = '?';
        if (isset($_GET['per_page'])) {
            $queryStringConcat .= ($queryStringConcat == '') ? '?per_page=' . $_GET['per_page'] : '&per_page=' . $_GET['per_page'];
        }
        if (isset($_GET['page'])) {
            $queryStringConcat .= ($queryStringConcat == '') ? '?page=' . $_GET['page'] : '&page=' . $_GET['page'];
        }
        $filter = array(
            'per_page' => (request()->input('per_page') != NULL) ? request()->input('per_page') : Setting::where('config_key', 'general|setting|pagePerAdminRecords')->get('value')[0]['value'],
            'order_by' => (request()->input('order_by') != NULL) ? request()->input('order_by') : 'created_at',
            'sorting' => (request()->input('sorting') != NULL) ? request()->input('sorting') : 'desc',
            'supplier_id' => (request()->input('supplier_id') != NULL) ? request()->input('supplier_id') : '',
            'service_id' => (request()->input('service_id') != NULL) ? request()->input('service_id') : '',
            'booking_id' => (request()->input('booking_id') != NULL) ? request()->input('booking_id') : '',
            'booking_status' => (request()->input('booking_status') != NULL) ? request()->input('booking_status') : '',
            'agency_id' => (request()->input('agency_id') != NULL) ? request()->input('agency_id') : '',
            'status' => (request()->input('status') != NULL) ? request()->input('status') : '',
        );
        if (request()->input('full_name') != NULL) {
            $fullName = request()->input('full_name');
            $filter['where'][] = [
                DB::raw("CONCAT(first_name, ' ', last_name)"),
                'LIKE',
                '%' . $fullName . '%'
            ];
        }
        if (request()->input('booking_date') != NULL) {
            $filter['where'][] = ['booking_date', 'like', '%' . request()->input('booking_date') . '%'];
        }
        if (request()->input('supplier_id') != NULL) {
            $filter['where'][] = ['supplier_id', '=', request()->input('supplier_id')];
        }
        if (request()->input('service_id') != NULL) {
            $filter['where'][] = ['service_id', '=', request()->input('service_id')];
        }
        if (request()->input('booking_id') != NULL) {
            $filter['where'][] = ['id', '=', request()->input('booking_id')];
        }
        if (request()->input('booking_status') != NULL) {
            $filter['where'][] = ['booking_status', '=', request()->input('booking_status')];
        }
        if (request()->input('agency_id') != NULL) {
            $filter['where'][] = ['agency_id', '=', request()->input('agency_id')];
        }
        if (request()->input('customer_name') != NULL) {
            $fullName = request()->input('customer_name');
            $filter['whereHas'][] = [
                DB::raw("CONCAT(first_name, ' ', last_name)"),
                'LIKE',
                '%' . $fullName . '%'
            ];
        }

        if (request()->input('email') != NULL) {
            $filter['where'][] = ['customers.email', 'like', '%' . request()->input('email') . '%'];
        }
        if (request()->input('price_from') != NULL) {
            $filter['where'][] = ['sub_total', '>=', request()->input('price_from')];
        }
        if (request()->input('price_to') != NULL) {
            $filter['where'][] = ['sub_total', '<=', request()->input('price_to')];
        }
        if (request()->input('status') != NULL) {
            $filter['where'][] = ['customers.status', '=', request()->input('status')];
        }
        // echo "<pre>";print_r($filter);die;
        $bookingListData = Bookings::getBookings($filter);
        $bookingDataCount = Bookings::count();
        $bookingData = $bookingListData['data'];
        $supplierDataList = Suppliers::get()->toArray();
        $getServiceType = ServiceType::get()->toArray();
        $getAgency = Agency::get()->toArray();
        $activityLog['request'] =  request()->input();
        $activityLog['request_url'] =  request()->url();
        $activityLog['response'] =  $bookingData;
        ActiveLog::createBackendActiveLog($activityLog);
        $suppliers = [];
        if ($supplierDataList) {
            foreach ($supplierDataList as $value) {
                $suppliers[$value['id']] = $value['name'];
            }
        }

        if ($bookingListData['status'] == 1) {
            return view('admin/booking/index')->with(['header' => $header, 'getAgency' => $getAgency, 'getServiceType' => $getServiceType, 'supplierDataList' => $supplierDataList, 'suppliers' => $suppliers, 'bookingData' => $bookingData, 'bookingDataCount' => $bookingDataCount, 'queryStringConcat' => $queryStringConcat, 'appliedFilter' => $filter, 'i' => (request()->input('page', 1) - 1) * $filter['per_page']]);
        } else {
            return view('admin/booking/index')->with(['error' => $bookingListData['message'], 'header' => $header, 'bookingData' => $bookingData, 'bookingDataCount' => $bookingDataCount, 'queryStringConcat' => $queryStringConcat, 'appliedFilter' => $filter, 'i' => (request()->input('page', 1) - 1) * $filter['per_page']]);
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id, $locale = Locale::English->value)
    {
        $header['title'] = "View Booking";
        $header['heading'] = "View Booking";

        $filter = array(
            'id' => $id
        );


        $bookingListData = Bookings::getBookings($filter);
        $bookingData = $bookingListData['data'];
        $activityLog['request'] =  request()->input();
        $activityLog['request_url'] =  request()->url();
        $activityLog['response'] =  $bookingData;
        $mode = "download";
        $invoiceSettings = InvoiceSetting::first();
        view()->share('invoiceSettings', $invoiceSettings);

        $pageDetails = null;
        if (!empty($bookingData)) {
            if ($mode == "download") {
                if ($bookingData->booking_type == "Hotel") {

                    $bookingNotes = '';
                    $editedHotelDetails = EditHotelDetail::where('booking_id', $id)->get();
                    $pageId = Page::where('page_code', 'important-information-hotel')->orWhere('slug_url', 'important-information-hotel')->select('id')->first();
                    if ($pageId) {
                        $pageDetails = PageI18ns::where('page_id', $pageId->id)->where('language_code', $locale)->first();
                    }

                    $bookingDetails = json_decode($editedHotelDetails[0], true);

                    $bookingDetails = [
                        'booking_details' => json_decode($bookingDetails['booking_details'], true)
                    ];
                    $tranlatedHotelDetails = TranslateBookingDetails::translateHotelBookingDetails($bookingDetails, $locale);
                    $editedHotelDetails[0]->booking_details = json_encode($tranlatedHotelDetails['booking_details']);
                    // $editedHotelDetails = collect($editedHotelDetails);
                    // dd($editedHotelDetails);

                    if ($locale == Locale::English->value) {
                        return view('admin/booking/download_voucher_hotel')->with(['header' => $header, 'bookingDetail' => $bookingData, 'bookingNotes' => $bookingNotes, 'editedHotelDetails' => $editedHotelDetails, 'pageDetails' => $pageDetails]);
                    }

                    return view('admin/booking/download_voucher_hotel_ar')->with(['header' => $header, 'bookingDetail' => $bookingData, 'bookingNotes' => $bookingNotes, 'editedHotelDetails' => $editedHotelDetails, 'pageDetails' => $pageDetails]);
                } else {
                    return view('admin/booking/download_invoice_flight')->with(['header' => $header, 'bookingDetail' => $bookingData]);
                }
            } else {
                return view('admin/booking/view')->with(['header' => $header, 'bookingDetail' => $bookingData]);
            }
        } else {
            return redirect()->route('booking.index')->with('error', 'something went wrong');
        }
    }



    public function showTest($id, $locale)
    {
        $header['title'] = "View Booking";
        $header['heading'] = "View Booking";

        $filter = array(
            'id' => $id
        );


        $bookingListData = Bookings::getBookings($filter);
        $bookingData = $bookingListData['data'];
        $activityLog['request'] =  request()->input();
        $activityLog['request_url'] =  request()->url();
        $activityLog['response'] =  $bookingData;
        $mode = "download";
        $pageDetails = null;
        if (!empty($bookingData)) {
            if ($mode == "download") {
                if ($bookingData->booking_type == "Hotel") {

                    $bookingNotes = '';
                    $editedHotelDetails = EditHotelDetail::where('booking_id', $id)->get();
                    $pageId = Page::where('page_code', 'important-information-hotel')->orWhere('slug_url', 'important-information-hotel')->select('id')->first();
                    if ($pageId) {
                        $pageDetails = PageI18ns::where('page_id', $pageId->id)->where('language_code', 'ar')->first();
                    }

                    $bookingDetails = json_decode($editedHotelDetails[0], true);

                    $bookingDetails = [
                        'booking_details' => json_decode($bookingDetails['booking_details'], true)
                    ];
                    $tranlatedHotelDetails = TranslateBookingDetails::translateHotelBookingDetails($bookingDetails, $locale);
                    $editedHotelDetails[0]->booking_details = json_encode($tranlatedHotelDetails['booking_details']);
                    // $editedHotelDetails = collect($editedHotelDetails);
                    // dd($editedHotelDetails);

                    if ($locale == Locale::English->value) {
                        return view('admin/booking/download_voucher_hotel')->with(['header' => $header, 'bookingDetail' => $bookingData, 'bookingNotes' => $bookingNotes, 'editedHotelDetails' => $editedHotelDetails, 'pageDetails' => $pageDetails]);
                    }

                    return view('admin/booking/download_voucher_hotel_ar')->with(['header' => $header, 'bookingDetail' => $bookingData, 'bookingNotes' => $bookingNotes, 'editedHotelDetails' => $editedHotelDetails, 'pageDetails' => $pageDetails]);
                } else {
                    return view('admin/booking/download_invoice_flight')->with(['header' => $header, 'bookingDetail' => $bookingData]);
                }
            } else {
                return view('admin/booking/view')->with(['header' => $header, 'bookingDetail' => $bookingData]);
            }
        } else {
            return redirect()->route('booking.index')->with('error', 'something went wrong');
        }
    }




    public function show_invoice($id, $locale = Locale::English->value)
    {
        $header['title'] = "View Booking";
        $header['heading'] = "View Booking";

        $filter = array(
            'id' => $id
        );

        $mode = 'download';

        $bookingListData = Bookings::getBookings($filter);
        $bookingData = $bookingListData['data'];
        $activityLog['request'] =  request()->input();
        $activityLog['request_url'] =  request()->url();
        $activityLog['response'] =  $bookingData;
        $invoiceSettings = InvoiceSetting::first();
        view()->share('invoiceSettings', $invoiceSettings);
        if (!empty($bookingData)) {
            if ($mode == "download") {
                if ($bookingData->booking_type == EnumsServiceType::Hotel->value) {

                    $bookingNotes = '';
                    $editedHotelDetails = EditHotelDetail::where('booking_id', $id)->first();
                    if (!$editedHotelDetails || !$editedHotelDetails->booking_details) {
                        return redirect()->route('booking.index')->with('error', 'Unable to download Invoice. Please try again later');
                    }
                    $bookingDetails = json_decode($editedHotelDetails->booking_details, true);
                    $bookingDetails = [
                        'booking_details' => $bookingDetails
                    ];
                    $tranlatedHotelDetails = TranslateBookingDetails::translateHotelBookingDetails($bookingDetails, $locale);
                    $editedHotelDetails->booking_details = json_encode($tranlatedHotelDetails['booking_details']);

                    if ($locale == Locale::English->value) {
                        return view('admin.booking.download_hotel_invoice')->with(['header' => $header, 'bookingDetail' => $bookingData, 'bookingNotes' => $bookingNotes, 'editedHotelDetails' => $editedHotelDetails, 'invoiceSettings' => $invoiceSettings]);
                    }
                    return view('admin.booking.download_hotel_invoice_ar')->with(['header' => $header, 'bookingDetail' => $bookingData, 'bookingNotes' => $bookingNotes, 'editedHotelDetails' => $editedHotelDetails, 'invoiceSettings' => $invoiceSettings]);
                } else {
                    $editedFlightDetails = EditFlightDetail::where('booking_id', $id)->first();
                    if (!$editedFlightDetails || !$editedFlightDetails->booking_details) {
                        return redirect()->route('booking.index')->with('error', 'Unable to download Invoice. Please try again later');
                    }
                    $bookingDetails = json_decode($editedFlightDetails->booking_details, true);
                    $bookingDetails = [
                        'booking_details' => [
                            'booking_details' => $bookingDetails
                        ]
                    ];
                    $tranlatedFlightDetails = TranslateBookingDetails::translateFlightBookingDetails($bookingDetails, $locale);
                    $editedFlightDetails->booking_details = json_encode($tranlatedFlightDetails['booking_details']['booking_details']);
                    if ($locale == Locale::English->value) {
                        return view('admin.booking.download_invoice_flight')->with(['header' => $header, 'bookingDetail' => $bookingData, 'editedFlightDetails' => $editedFlightDetails]);
                    }
                    return view('admin.booking.download_invoice_flight_ar')->with(['header' => $header, 'bookingDetail' => $bookingData, 'editedFlightDetails' => $editedFlightDetails]);
                }
            } else {
                return redirect()->route('booking.index')->with('error', 'Something Went wrong');
            }
        } else {
            return redirect()->route('booking.index')->with('error', 'Something Went wrong');
        }
    }



    public function cancelBooking($id)
    {
        $cancelStatus = '';
        $bookingRef = '';
        $where = [
            [
                'field' => 'id',
                'condition' => '=',
                'value' => $id
            ],
            [
                'field' => 'booking_status',
                'condition' => '=',
                'value' => BookingStatus::Confirmed->value
            ]
        ];
        $message = '';
        $bookingDetailsResponse = Bookings::getBooking($where);
        if ($bookingDetailsResponse['status'] == 'true') {
            $bookingDetails = $bookingDetailsResponse['data'][0];
            $bookingRef = $bookingDetails['booking_ref'];
            $bookingSupplierNumber = $bookingDetails['supplier_booking_associated_ref'];
            $bookingSegmentId = $bookingDetails['booking_segment_id'];
            $message = 'Unable to cancel the booking "' . $bookingRef . '". ';
            switch ($bookingDetails['booking_type']) {
                case 'Flight':
                    $data = [
                        'booking_status' => BookingStatus::Cancelled_Not_Refunded->value,
                        'booking_sub_status' => '',
                        'booking_status_message' => 'After booking cancelled by Backoffice User - ' . Auth::user()->name,
                        'booking_cancel_amount' => '',
                        'booking_cancel_at' => Carbon::now(),
                        'service_provider_cancel_response' => ''
                    ];
                    $is_updated = Bookings::updateBooking($id, $data);
                    if ($is_updated) {
                        $cancelStatus = 'CANCELLED';
                    }

                    BookingStatusLog::create([
                        'booking_id' => $id,
                        'booking_status_from' => $bookingDetails['booking_status'],
                        'booking_status_to' => BookingStatus::Cancelled_Not_Refunded,
                        'booking_status_description' => 'After booking cancelled by Backoffice User - ' . Auth::user()->name,
                        'modified_by' => Auth::id(),
                    ]);

                    // $bookingCancellationDetails = $this->flightBookingCancel($bookingSupplierNumber);
                    // if ($bookingCancellationDetails['http_code'] == 204) {
                    //     $cancelStatus = 'CANCELLED';

                    //     $data = [
                    //         'booking_status' => 'cancelled-not-refunded',
                    //         'booking_status_message' => 'After booking cancelled by Admin',
                    //         'booking_cancel_amount' => '',
                    //         'booking_cancel_at' => Carbon::now(),
                    //         'service_provider_cancel_response' => $bookingCancellationDetails['response']
                    //     ];
                    //     Bookings::updateBooking($id, $data);

                    //     $supplierParentLogId = $this->getSupplierLogParentIdForBooking($id);
                    //     if ($supplierParentLogId != '') {
                    //         $this->createSupplierLog('Flight', 'Amadeus', 'flight-cancel-order', '', json_encode($bookingCancellationDetails['response']), $bookingDetails['customer_id']);
                    //     }
                    // } else {
                    //     $message .= $bookingCancellationDetails['message'];
                    // }
                    break;
                case 'Hotel':
                    if ($bookingDetails['service_provider'] === 'GIMMONIX') {
                        return $bookingCancellationDetails = $this->gimmonixCancelBooking($bookingSegmentId);

                        //echo "<pre>"; echo 'SegmentID:'.$bookingSegmentId; echo json_encode($bookingCancellationDetails); die;
                        if ($bookingCancellationDetails['status'] == true) {
                            $cancelStatus = $bookingCancellationDetails['data']['Status'];
                            $cancelAmount = $bookingCancellationDetails['data']['CancellationFee'];
                            if ($cancelStatus == 'CX') {
                                if ($cancelAmount == 0) {
                                    BookingStatusLog::create([
                                        'booking_id' => $id,
                                        'booking_status_from' => $bookingDetails['booking_status'],
                                        'booking_status_to' => BookingStatus::Cancelled_Not_Refunded->value,
                                        'booking_status_description' => 'After booking cancelled by Backoffice User - ' . Auth::user()->name,
                                        'modified_by' => Auth::id(),
                                    ]);
                                    $data = [
                                        'booking_status' => BookingStatus::Cancelled_Not_Refunded->value,
                                        'booking_status_message' => 'After booking cancelled by Backoffice User - ' . Auth::user()->name,
                                        'booking_cancel_amount' => $cancelAmount,
                                        'booking_cancel_at' => Carbon::now(),
                                        'service_provider_cancel_response' => $bookingCancellationDetails
                                    ];
                                } else {
                                    BookingStatusLog::create([
                                        'booking_id' => $id,
                                        'booking_status_from' => $bookingDetails['booking_status'],
                                        'booking_status_to' => BookingStatus::Cancelled->value,
                                        'booking_status_description' => 'After booking cancelled by Backoffice User - ' . Auth::user()->name,
                                        'modified_by' => Auth::id(),
                                    ]);
                                    $data = [
                                        'booking_status' => BookingStatus::Cancelled->value,
                                        'booking_status_message' => 'After booking cancelled by Backoffice User - ' . Auth::user()->name,
                                        'booking_cancel_amount' => $cancelAmount,
                                        'booking_cancel_at' => Carbon::now(),
                                        'service_provider_cancel_response' => $bookingCancellationDetails
                                    ];
                                }
                                Bookings::updateBooking($id, $data);

                                $traacsRefundResponse = $this->refundVoucherInTraacs($id);

                                $cancelStatus = 'CANCELLED';
                            }
                        } else {
                            $message .= $bookingCancellationDetails['message'];
                        }
                        $supplierParentLogId = $this->getSupplierLogParentIdForBooking($id);
                        if ($supplierParentLogId != '') {
                            $this->createSupplierLog('Hotel', 'Gimmonix', 'hotel-cancel-order', '', json_encode($bookingCancellationDetails), $bookingDetails['customer_id']);
                        }
                    } else {
                        $bookingCancellationDetails = $this->hotelCancelBooking($bookingSupplierNumber);
                        if ($bookingCancellationDetails['status'] == 'true') {
                            $cancelStatus = $bookingCancellationDetails['data']['status'];
                            $cancelAmount = $bookingCancellationDetails['data']['hotel']['cancellationAmount'];
                            if ($cancelStatus == 'CANCELLED') {
                                $data = [
                                    'booking_status' => BookingStatus::Cancelled_Not_Refunded->value,
                                    'booking_status_message' => 'After booking cancelled by Backoffice User - ' . Auth::user()->name,
                                    'booking_cancel_amount' => $cancelAmount,
                                    'booking_cancel_at' => Carbon::now(),
                                    'service_provider_cancel_response' => $bookingCancellationDetails['response']
                                ];
                                Bookings::updateBooking($id, $data);

                                $traacsRefundResponse = $this->refundVoucherInTraacs($id);

                                $supplierParentLogId = $this->getSupplierLogParentIdForBooking($id);
                                if ($supplierParentLogId != '') {
                                    $this->createSupplierLog('Hotel', 'Hotel Beds', 'hotel-cancel-order', '', json_encode($bookingCancellationDetails['response']), $bookingDetails['customer_id']);
                                }
                            }
                        } else {
                            $message .= $bookingCancellationDetails['message'];
                        }
                    }
                    break;
            }
        }
        $status = 'error';
        $message = 'Unable to Cancel Booking "' . $bookingRef . '" ';
        $response = array(
            'status' => 0,
            'message' => $message,
            'data' => []
        );
        if ($cancelStatus == 'CANCELLED') {
            $status = 'success';
            $response = array(
                'status' => 1,
                'message' => '',
                'data' => []
            );
            $message = 'Booking "' . $bookingRef . '" have cancelled successfully.';
            return redirect()->route('booking.index', $response)->with($status, $message);
        } else {
            return redirect()->route('booking.index', $response)->with($status, $message);
        }
        die;
    }

    public function refundBooking($id, Request $request)
    {
        $bookingDetails = Bookings::whereId($id)->first();

        if ($bookingDetails) {
            $bookingDetails = $bookingDetails->toArray();
            $paymentDetails = Payment::where('booking_id', $id)->first()->toArray();
            $paymentId = ($paymentDetails['payment_type'] == 'DB') ? $paymentDetails['debit_id'] : $paymentDetails['capture_id'];
            $processedCancelAmount = $request->input('amount');
            $paymentBrand = $paymentDetails['payment_brand'];
            $currency = $bookingDetails['customer_currency'];

            $refundResponse = $this->refundPayment($paymentId, $paymentBrand, $processedCancelAmount, $currency);
            $updatePaymentPayload = [
                'payment_status' => $paymentDetails['payment_status'] . '-' . 'Refunded',
                'booking_cancel_amount' => $bookingDetails['booking_cancel_amount'],
                'refund_amount' => $processedCancelAmount,
                'refund_status' => ($refundResponse['status'] == 'true') ? 'success' : 'failure',
                'refund_response' => $refundResponse['data'],
                'refund_at' => Carbon::now(),
            ];
            Payment::updatePayment($paymentDetails['id'], $updatePaymentPayload);

            if ($refundResponse['status'] == 'true') {
                $updateBookingPayload = [
                    'booking_status' => BookingStatus::Cancelled_And_Refunded->value,
                    'booking_sub_status' => 'Refunded',
                    'booking_status_message' => $processedCancelAmount . ' ' . $currency . ' have refunded successfully by Backoffice User - ' . Auth::user()->name,
                    'processed_cancel_amount' => $processedCancelAmount
                ];
                Bookings::updateBooking($id, $updateBookingPayload);
                BookingStatusLog::create([
                    'booking_id' => $id,
                    'booking_status_from' => $bookingDetails['booking_status'],
                    'booking_status_to' => BookingStatus::Cancelled_And_Refunded->value,
                    'booking_status_description' => 'After booking refunded by Backoffice User - ' . Auth::user()->name,
                    'refund_amount' => $processedCancelAmount,
                    'modified_by' => Auth::id(),
                ]);

                $response = array(
                    'status' => 1,
                    'message' => '',
                    'data' => []
                );
                $message = 'Booking "' . $bookingDetails['booking_ref'] . '" have refunded successfully.';
                return redirect()->route('booking.index', $response); //->with('success', $message);
            } else {
                return redirect()->route('booking.index')->with('error', 'Unable to refund.');
            }
        } else {
            return redirect()->route('booking.index')->with('error', 'Unable to find the booking.');
        }
        die;
    }

    public function supplierLog($id)
    {
        $bookingLogs = $this->getSupplierLogForBooking($id);
        if (count($bookingLogs) > 0) {
            $supplierReference = '';
            $jsonFiles = [];
            $logDirectory = 'public';
            $logFileNamePrefix = 'log';
            foreach ($bookingLogs as $bookingLog) {
                if ($supplierReference == '' && $bookingLog['supplier_reference'] != '') {
                    $supplierReference = $bookingLog['supplier'] . '-' . $bookingLog['supplier_reference'];
                }
                if ($bookingLog['request'] != '') {
                    $fileName = $bookingLog['log_type'] . '-request.json';
                    Storage::disk($logDirectory)->put($fileName, $bookingLog['request']);
                    array_push($jsonFiles, $fileName);
                }
                if ($bookingLog['response'] != '') {
                    $fileName = $bookingLog['log_type'] . '-response.json';
                    Storage::disk($logDirectory)->put($fileName, $bookingLog['response']);
                    array_push($jsonFiles, $fileName);
                }
            }
            $bookingDetails = Bookings::select('booking_status', 'service_provider_cancel_response')
                ->whereId($id)
                ->first();
            if ($bookingDetails) {
                $bookingDetails = $bookingDetails->toArray();
                if ($bookingDetails['booking_status'] == BookingStatus::Cancelled->value) {
                    $fileName = 'hotel-order-cancellation-response.json';
                    Storage::disk($logDirectory)->put($fileName, $bookingDetails['service_provider_cancel_response']);
                    array_push($jsonFiles, $fileName);
                }
            }
            if ($supplierReference != '') {
                $logFileNamePrefix = $supplierReference;
            }
            if (count($jsonFiles) > 0) {
                $zip = new \ZipArchive();
                $logFileName = $logFileNamePrefix . '.zip';
                if ($zip->open(public_path($logFileName), \ZipArchive::CREATE) == TRUE) {
                    foreach ($jsonFiles as $jsonFile) {
                        $zip->addFile(public_path("storage/" . $jsonFile), $jsonFile);
                    }
                }
                $zip->close();
                foreach ($jsonFiles as $jsonFile) {
                    @unlink(public_path("storage/" . $jsonFile));
                }
                return response()->download(public_path($logFileName));
            }
        }
    }

    public function download($id)
    {

        $header['title'] = "View Booking";
        $header['heading'] = "View Booking";

        $filter = array(
            'id' => $id
        );

        //echo "<pre>";print_r($filter);die;
        $bookingListData = Bookings::getBookings($filter);
        $bookingDataCount = Bookings::count();
        $bookingData = $bookingListData['data'];

        $supplierDataList = Suppliers::get()->toArray();
        $getServiceType = ServiceType::get()->toArray();
        $getAgency = Agency::get()->toArray();
        $activityLog['request'] =  request()->input();
        $activityLog['request_url'] =  request()->url();
        $activityLog['response'] =  $bookingData;
        // ActiveLog::createBackendActiveLog($activityLog);
        // echo "<pre>";print_r($bookingData);die;
        $bookingNotes = "";
        if (!empty($bookingData)) {
            if ($bookingData->booking_type == "Hotel") {

                $supplierResponse = json_decode($bookingData->service_provider_response, true);
                //echo "<pre>";
                //print_r($supplierResponse);die;
                $bookingNotes = 'Payable through ' . $supplierResponse['booking']['hotel']['supplier']['name'] . ', acting as agent for the service operating company, details of which can be provided upon request. VAT: ' . $supplierResponse['booking']['hotel']['supplier']['vatNumber'] . ' Reference: ' . $supplierResponse['booking']['reference'];
                return view('admin/booking/download_hotel')->with(['header' => $header, 'bookingDetail' => $bookingData, 'bookingNotes' => $bookingNotes]);
            } else {
                return view('admin/booking/download')->with(['header' => $header, 'bookingDetail' => $bookingData]);
            }
        } else {
            return redirect()->route('booking.index')->with('error', '');
        }
    }

    private static  function checkAuthenticated($isApi = false)
    {
        if (!$isApi) {
            if (!Auth::check()) {
                return response()->view('admin.404', [], 404);
            }
        }
    }


    public function downloadInvoice($id, $locale = Locale::English->value)
    {
        $baseUrl = url('/');
        $isApi = request()->is('api/v1/*');
        
        $auth = self::checkAuthenticated($isApi);

        if ($auth instanceof \Illuminate\Http\Response) {
            return $auth;
        }

        $prefix = $isApi ? 'api/v1/' : '';

        $filename = "ticket_pdf/" . rand() . ".pdf";
        $url = $baseUrl . '/' . $prefix . 'booking/show_invoice/' . $id . '/' .  $locale;
        $where = [
            [
                'field' => 'id',
                'condition' => '=',
                'value' => $id
            ]
        ];

        $bookingDetailsResponse = Bookings::getBooking($where);

        if ($bookingDetailsResponse['status'] == 'true') {
            $bookingDetails = $bookingDetailsResponse['data'][0];
            $filename = $bookingDetails['booking_ref'] . ".pdf";
        }

        $pdf_file_url = public_path("voucher/" . $filename);

        // Ensure the directory exists
        if (!file_exists(public_path("voucher"))) {
            mkdir(public_path("voucher"), 0755, true);
        }


        // dd($pdf_file_url);

        // Generate the PDF with wkhtmltopdf
        // $cmd = escapeshellcmd("wkhtmltopdf --enable-local-file-access $url $pdf_file_url");
        $cmd =  "wkhtmltopdf $url $pdf_file_url 2>&1";
        $output = [];
        exec($cmd, $output, $return_var);
        // echo "JJ";
        // exit();
        if ($return_var !== 0) {
            // Handle error
            // dd($output);
        }

        // Output the file
        if (file_exists($pdf_file_url)) {
            header("Content-type: application/pdf");
            header("Content-Disposition: attachment; filename=" . $filename);
            readfile($pdf_file_url);
            exit;
        } else {
            abort(404, 'PDF not generated');
        }
    }




    public function downloadVocher($id, $locale = Locale::English->value)
    {
        $baseUrl = url('/');
        $filename = "ticket_pdf/" . rand() . ".pdf";
        $isApi = request()->is('api/v1/*');

        $auth = self::checkAuthenticated($isApi);

        if ($auth instanceof \Illuminate\Http\Response) {
            return $auth;
        }

        $prefix = $isApi ? 'api/v1/' : '';
        $url = $baseUrl . '/' . $prefix . 'booking/show_voucher/' . $id . '/' . $locale;

        $where = [
            [
                'field' => 'id',
                'condition' => '=',
                'value' => $id
            ]
        ];

        $bookingDetailsResponse = Bookings::getBooking($where);

        if ($bookingDetailsResponse['status'] == 'true') {
            $bookingDetails = $bookingDetailsResponse['data'][0];
            $filename = $bookingDetails['booking_ref'] . ".pdf";
        }

        $pdf_file_url = public_path("voucher/" . $filename);

        // Ensure the directory exists
        if (!file_exists(public_path("voucher"))) {
            mkdir(public_path("voucher"), 0755, true);
        }

        // Generate the PDF with wkhtmltopdf
        // $cmd = escapeshellcmd("wkhtmltopdf --enable-local-file-access $url $pdf_file_url");
        $cmd =  "wkhtmltopdf $url $pdf_file_url 2>&1";
        $output = [];
        exec($cmd, $output, $return_var);
        // echo "JJ";
        // exit();
        if ($return_var !== 0) {
            // Handle error
            // dd($output);
        }

        // Output the file
        if (file_exists($pdf_file_url)) {
            header("Content-type: application/pdf");
            header("Content-Disposition: attachment; filename=" . $filename);
            readfile($pdf_file_url);
            exit;
        } else {
            abort(404, 'PDF not generated');
        }
    }


    public function downloadVocherTest($id, $locale = '')
    {
        $baseUrl = url('/');
        $filename = "ticket_pdf/" . rand() . ".pdf";
        $isApi = request()->is('api/v1/*');

        $prefix = $isApi ? 'api/v1/' : '';
        $url = $baseUrl . '/' . $prefix . 'booking/show_voucher_test/' . $id . '/' . $locale;

        $where = [
            [
                'field' => 'id',
                'condition' => '=',
                'value' => $id
            ]
        ];

        $bookingDetailsResponse = Bookings::getBooking($where);

        if ($bookingDetailsResponse['status'] == 'true') {
            $bookingDetails = $bookingDetailsResponse['data'][0];
            $filename = $bookingDetails['booking_ref'] . ".pdf";
        }

        $pdf_file_url = public_path("voucher/" . $filename);

        // Ensure the directory exists
        if (!file_exists(public_path("voucher"))) {
            mkdir(public_path("voucher"), 0755, true);
        }

        // Generate the PDF with wkhtmltopdf
        // $cmd = escapeshellcmd("wkhtmltopdf --enable-local-file-access $url $pdf_file_url");
        $cmd =  "wkhtmltopdf $url $pdf_file_url 2>&1";
        $output = [];
        exec($cmd, $output, $return_var);
        // echo "JJ";
        // exit();
        if ($return_var !== 0) {
            // Handle error
            // dd($output);
        }

        // Output the file
        if (file_exists($pdf_file_url)) {
            header("Content-type: application/pdf");
            header("Content-Disposition: attachment; filename=" . $filename);
            readfile($pdf_file_url);
            exit;
        } else {
            abort(404, 'PDF not generated');
        }
    }



    public function downloadTicket_old($id)
    {

        //         if (function_exists('exec')) {
        //     echo 'exec() is enabled';
        // } else {
        //     echo 'exec() is disabled';
        // }
        // exit();

        $baseUrl = url('/');
        $filename = "ticket_pdf/" . rand() . ".pdf";
        $url = $baseUrl . "/booking/download/" . $id;

        $where = [
            [
                'field' => 'id',
                'condition' => '=',
                'value' => $id
            ]
        ];
        $message = '';
        $bookingDetailsResponse = Bookings::getBooking($where);



        if ($bookingDetailsResponse['status'] == 'true') {
            $bookingDetails = $bookingDetailsResponse['data'][0];
            $filename = $bookingDetails['booking_ref'] . ".pdf";
        }

        // $filename = rand().".pdf";
        $pdf_file_url = $_SERVER["DOCUMENT_ROOT"] . "/voucher/" . $filename;
        $cmd = "wkhtmltopdf $url $pdf_file_url 2>&1";

        // dd($pdf_file_url);

        exec($cmd);
        $file = $baseUrl . "/" . $filename;
        header("Content-type: application/pdf");
        header("Content-Disposition: attachment; filename=" . $file);
        readfile($file);
        die;
        //$file = 'ticket_pdf/' . $propsId . '.pdf';

        //die;
        //$result = file_get_contents("https://demo.mafhumalqima.com/cron/generatePDF?apikey=" . urlencode($apikey) . "&url=" . urlencode($url));
        $ch = curl_init();

        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_URL, $Endurl);
        curl_setopt(
            $ch,
            CURLOPT_POSTFIELDS,
            "url=" . $url
        );
        $data = curl_exec($ch);
        curl_close($ch);
        $file = "mypdf-1.pdf";
        file_put_contents('mypdf-1.pdf', $data);
        header("Content-type: application/pdf");
        header("Content-Disposition: inline; filename=" . $file);
        readfile($file);
        die;
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $header['title'] = "Booking - Edit";
        $header['heading'] = "Booking - Edit";
        $booking_detail = Bookings::findOrFail($id);

        $booking_details = json_decode($booking_detail->booking_details, true);
        $payment = Payment::where('booking_id', $id)
            ->latest()
            ->first();

        $cityDetails = CityI18n::select(
            'city_i18ns.city_id',
            DB::raw("MAX(CASE WHEN language_code = 'en' THEN city_name END) AS city_name_en"),
            DB::raw("MAX(CASE WHEN language_code = 'ar' THEN city_name END) AS city_name_ar")
        )
            ->orderBy('city_name')
            ->groupBy('city_i18ns.city_id')
            ->get();
        $countryDetails = CountryI18ns::select(
            'country_i18ns.country_id',
            DB::raw("MAX(CASE WHEN language_code = 'en' THEN country_name END) AS country_name_en"),
            DB::raw("MAX(CASE WHEN language_code = 'ar' THEN country_name END) AS country_name_ar")
        )
            ->orderBy('country_name')
            ->groupBy('country_i18ns.country_id')
            ->get();

        $additionalbookingDetails = BookingAdditionalDetail::where('booking_id', $id)->first();
        if ($booking_detail->booking_type == 'Flight') {

            if (!is_null($booking_detail->booking_details) && $booking_detail->booking_details != '') {
                $booking_details = json_decode($booking_detail->booking_details, true);
                $booking_details = $booking_details['booking_details'];
                $flightDetails = $booking_details['flightDetails'];
                $is_edited = EditFlightDetail::where('booking_id', $id)->exists();
                if (!$is_edited) {

                    $flightDetails = $booking_details['flightDetails'];

                    EditFlightDetail::create([
                        'booking_id' => $id,
                        'first_name' => $booking_detail->first_name,
                        'last_name' => $booking_detail->last_name,
                        'email' => $booking_detail->email,
                        'booking_date' => $booking_detail->booking_date,
                        'booking_start_date' => $booking_detail->booking_start_date,
                        'customer_details' => json_encode($booking_details['userDetails']),
                        'flight_details' => json_encode($flightDetails['flightInfo']),
                        'complete_flight_details' => json_encode($flightDetails),
                        'passenger_details' => json_encode($booking_details['passengerDetails']),
                        'payment_details' => json_encode($booking_details['paymentDetails']),
                        'processed_price' => json_encode($booking_details['processedPrice']),
                        'billing_details' => json_encode($booking_details['billingDetails']),
                    ]);
                }
                $existingBookingDetails = EditFlightDetail::where('booking_id', $id)->first();
                if (!$existingBookingDetails->complete_flight_details) {
                    EditFlightDetail::where('booking_id', $id)->update([
                        'complete_flight_details' => json_encode($flightDetails)
                    ]);
                }
            } else {

                $booking_details = BookingAdditionalDetail::where('booking_id', $id)->first();
                $booking_details = json_decode($booking_details->booking_details, true);
                $flightDetails = $booking_details['flightDetails'];
                $is_edited = EditFlightDetail::where('booking_id', $id)->exists();
                if (!$is_edited) {
                    $flightDetails = $booking_details['flightDetails'];
                    // $flightInfo = $flightDetails['airline']['flights'];

                    EditFlightDetail::create([
                        'booking_id' => $id,
                        'first_name' => $booking_detail->first_name,
                        'last_name' => $booking_detail->last_name,
                        'email' => $booking_detail->email,
                        'booking_date' => $booking_detail->booking_date,
                        'booking_start_date' => $booking_detail->booking_start_date,
                        'customer_details' => json_encode($booking_details['userDetails']),
                        'flight_details' => json_encode($flightDetails),
                        'complete_flight_details' => json_encode($flightDetails),
                        'passenger_details' => json_encode($booking_details['passengerDetails']),
                        'processed_price' => json_encode($booking_details['processedPrice']),
                        'billing_details' => json_encode($booking_details['billingDetails']),
                    ]);
                }
                $existingBookingDetails = EditFlightDetail::where('booking_id', $id)->first();
                if (!$existingBookingDetails->complete_flight_details) {
                    EditFlightDetail::where('booking_id', $id)->update([
                        'complete_flight_details' => json_encode($flightDetails)
                    ]);
                }
            }

            $existingBookingDetails = EditFlightDetail::where('booking_id', $id)->first();
            $existingFlightBookingData = json_decode($existingBookingDetails->booking_details, true);
            // dd(json_decode($existingBookingDetails->complete_flight_details));
            $flightDetails = $existingFlightBookingData['flightDetails'];
            $customerDetails = $existingFlightBookingData['userDetails'];
            $processedPrice = $existingFlightBookingData['processedPrice'];
            $billingDetails = $existingFlightBookingData['billingDetails'];

            $passengerDetails = $existingFlightBookingData['passengerDetails'];
            $serviceType = ServiceType::where('name', $booking_detail->booking_type)->value('id');
            $getSupplier = Suppliers::where('core_service_type_id', $serviceType)->first();

            $country_id = CustomerAddresses::where('customer_id', $customerDetails['userId'])
                ->latest()
                ->value('country');

            $country_details = CountryI18ns::where('country_id', $country_id)
                ->value('country_name');

            if ($country_details) {
                $customerDetails['country_name'] = $country_details;
            }

            $airlineDetails = AirlineI18ns::select(
                'airline_i18ns.airline_id',
                DB::raw("MAX(CASE WHEN language_code = 'en' THEN airline_name END) AS airline_name_en"),
                DB::raw("MAX(CASE WHEN language_code = 'ar' THEN airline_name END) AS airline_name_ar")
            )
                ->orderBy('airline_name')
                ->groupBy('airline_i18ns.airline_id')
                ->get();


            return view('admin.booking.edit-booking-flight')->with(['header' => $header, 'booking_id' => $id, 'existingBookingDetails' => $existingBookingDetails, 'additional_details' => $booking_detail, 'flight_details' => $flightDetails, 'passenger_details' => $passengerDetails, 'processed_price' => $processedPrice, 'billing_details' => $billingDetails, 'customer_details' => $customerDetails, 'supplier_provider' => $getSupplier, 'payment' => $payment, 'additionalBookingDetails' => $additionalbookingDetails, 'airlineDetails' => $airlineDetails, 'cityDetails' => $cityDetails, 'countryDetails' => $countryDetails]);
        }

        if ($booking_detail->booking_type == 'Hotel') {
            if (!is_null($booking_detail->booking_details) && $booking_detail->booking_details != '') {
                $booking_details = json_decode($booking_detail->booking_details, true);
                $is_edited = EditHotelDetail::where('booking_id', $id)->exists();
                if (!$is_edited) {
                    EditHotelDetail::create([
                        'booking_id' => $id,
                        'first_name' => $booking_detail->first_name,
                        'last_name' => $booking_detail->first_name,
                        'email' => $booking_detail->email,
                        'booking_date' => $booking_detail->booking_date,
                        'booking_start_date' => $booking_detail->booking_start_date,
                        'customer_details' => json_encode($booking_details['userDetails']),
                        'hotel_details' => json_encode($booking_details['hotelDetails']),
                        'search_details' => json_encode($booking_details['searchDetails']),
                        'processed_price' => json_encode($booking_details['processedPrice']),
                        'billing_details' => json_encode($booking_details['billingDetails']),
                        'booking_details' => json_encode($booking_details),
                    ]);
                }
            } else {
                $booking_details = BookingAdditionalDetail::where('booking_id', $id)->first();
                $booking_details = json_decode($booking_details->booking_details, true);
                $is_edited = EditHotelDetail::where('booking_id', $id)->exists();
                if (!$is_edited) {
                    EditHotelDetail::create([
                        'booking_id' => $id,
                        'first_name' => $booking_detail->first_name,
                        'last_name' => $booking_detail->first_name,
                        'email' => $booking_detail->email,
                        'booking_date' => $booking_detail->booking_date,
                        'booking_start_date' => $booking_detail->booking_start_date,
                        'customer_details' => json_encode($booking_details['userDetails']),
                        'hotel_details' => json_encode($booking_details['hotelDetails']),
                        'search_details' => json_encode($booking_details['searchDetails']),
                        'processed_price' => json_encode($booking_details['processedPrice']),
                        'billing_details' => json_encode($booking_details['billingDetails']),
                        'booking_details' => json_encode($booking_details),
                    ]);
                }
            }
            $getSupplier = BookingCheckout::where('booking_id', $booking_detail->id)->first();
            $supplier = '';
            if ($getSupplier) {
                $supplier = $getSupplier->supplier_name ?? 'N/A';
            }
            $existingHotelDetails = EditHotelDetail::where('booking_id', $id)->first();
            $existingHotelBookingData = json_decode($existingHotelDetails->booking_details, true);
            $customerDetails = $existingHotelBookingData['userDetails'];

            $search_details = $existingHotelBookingData['searchDetails'];
            $hotel_details = $existingHotelBookingData['hotelDetails'];
            $processed_price = $existingHotelBookingData['processedPrice'];
            $billing_details = $existingHotelBookingData['billingDetails'];


            $country_id = CustomerAddresses::where('customer_id', $customerDetails['userId'])
                ->latest()
                ->value('country');

            $country_details = CountryI18ns::where('country_id', $country_id)
                ->value('country_name');

            if ($country_details) {
                $customerDetails['country_name'] = $country_details;
            }



            return view('admin.booking.edit-booking-hotel')->with(['header' => $header, 'booking_id' => $id, 'booking_detail' => $existingHotelDetails, 'additional_details' => $booking_detail, 'search_details' => $search_details, 'hotel_details' => $hotel_details, 'processed_price' => $processed_price, 'billing_details' => $billing_details, 'customer_details' => $customerDetails, 'supplier_provider' => $supplier, 'payment' => $payment, 'cityDetails' => $cityDetails, 'countryDetails' => $countryDetails]);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function updateFlightDetails(Request $request, $id)
    {

        $validated = validator([
            'edit_type' => 'required',
        ]);

        $editFlightDetail = EditFlightDetail::where('booking_id', $id)->first();
        if (!$editFlightDetail) {
            return response()->json(['error' => 'Flight details not found'], 404);
        }

        $existingFlightBookingData = json_decode($editFlightDetail->booking_details, true);
        if (empty($existingFlightBookingData)) {
            return response()->json(['error' => 'Unable to update booking details'], 404);
        }
        if ($request->edit_type == 'customer_details') {


            $existingCustomer = $editFlightDetail;

            if (!$existingCustomer) {
                return response()->json(['error' => 'Customer not found'], 404);
            }
            $existingCustomer->first_name = $request->first_name ?? '';
            $existingCustomer->last_name = $request->last_name  ?? '';
            $existingCustomer->email = $request->customer_email  ?? '';
            $existingCustomer->booking_date = $request->booking_date  ?? '';
            $existingCustomer->booking_start_date = $request->booking_start_date  ?? '';
            $existingCustomer->save();


            $customerDetails = json_decode($editFlightDetail->customer_details, true);
            if (!$customerDetails || !is_array($customerDetails)) {
                $customerDetails = [];
            }
            $customerDetails['email'] = $request->customer_email ?? '';
            $customerDetails['phoneNumber'] = $request->phoneNumber ?? '';
            $editFlightDetail->customer_details = json_encode($customerDetails);

            if (!empty($existingFlightBookingData['userDetails'])) {
                $existingFlightBookingData['userDetails']['first_name'] = $request->first_name ?? '';
                $existingFlightBookingData['userDetails']['last_name'] = $request->first_name ?? '';
                $existingFlightBookingData['userDetails']['email'] = $request->customer_email ?? '';
                $existingFlightBookingData['userDetails']['phoneNumber'] = $request->phoneNumber ?? '';
                $editFlightDetail->booking_details = json_encode($existingFlightBookingData, JSON_UNESCAPED_UNICODE);
            }

            $editFlightDetail->save();

            return response()->json(['success' => 'Customer details updated successfully']);
        }


        if ($request->edit_type == 'flight_details') {
            $existingFlightBookingData = json_decode($editFlightDetail->booking_details);
            $existingFlightDetails = $existingFlightBookingData->flightDetails;
            if (!$existingFlightDetails) {
                return response()->json(['error' => 'No flight details found'], 404);
            }
            $requestData = $request->all();
            $airlineDetails = $existingFlightDetails->airlines ?? [];
            foreach ($airlineDetails as $airlineIndex => &$airline) {
                foreach ($airline->flights as $flightIndex => &$flight) {
                    foreach ($flight->segments as $segmentIndex => &$segment) {

                        if (
                            !isset($requestData['segments'][$flightIndex]) ||
                            !isset($requestData['segments'][$flightIndex][$segmentIndex])
                        ) {
                            continue;
                        }

                        $requestSegment = $requestData['segments'][$flightIndex][$segmentIndex];
                        $dbAirlineData = AirlineI18ns::select('airline_id')
                            ->where('airline_name', $requestSegment['airline_name'])
                            ->first();

                        if ($dbAirlineData) {
                            $dbAirlineCode = Airline::select('airline_code')
                                ->whereId($dbAirlineData->airline_id)
                                ->first();


                            if ($dbAirlineCode) {
                                $airlineCode = $dbAirlineCode->airline_code;
                                $segment->airlineData->code = $airlineCode ?? $segment->airlineData->code;

                                // Folder path where logos are stored
                                $logoDir = storage_path('app/public/airlineLogo');

                                $files = \glob($logoDir . '/' . $airlineCode . '.*');
                                if (!empty($files)) {
                                    $fileName = basename($files[0]);
                                    $logo = URL::to('/storage/airlineLogo/' . $fileName);
                                } else {
                                    $logo = $segment->airlineData->logo;
                                }

                                $segment->airlineData->logo = $logo;
                            }
                        }

                        $segment->airlineData->name = $requestSegment['airline_name'];
                        $segment->aircraftData->name = $requestSegment['aircraft_name'];
                        $segment->carrierCode = explode(' ', $requestSegment['flight_number'])[0];
                        $segment->number = explode(' ', $requestSegment['flight_number'])[1] ?? '';

                        $segment->departureDate = $requestSegment['departure_time'];
                        $segment->departure->at = $requestSegment['departure_time'];
                        $segment->departure->iataCode = $requestSegment['departure_iata'];
                        $segment->departureAirportData->city_name = $requestSegment['departure_city'];
                        $segment->departureAirportData->country_name = $requestSegment['departure_country'];
                        $segment->departure->terminal = $requestSegment['departure_terminal'];

                        $segment->durationText = $requestSegment['duration'];

                        $segment->arrivalDate =  $requestSegment['arrival_time'];
                        $segment->arrival->at =  $requestSegment['arrival_time'];
                        $segment->arrival->iataCode = $requestSegment['arrival_iata'];
                        $segment->arrivalAirportData->city_name = $requestSegment['arrival_city'];
                        $segment->arrivalAirportData->country_name = $requestSegment['arrival_country'];
                        $segment->arrival->terminal = $requestSegment['arrival_terminal'];
                    }
                    unset($segment);
                }
                unset($flight);
            }
            unset($airline);

            $editFlightDetail->booking_details = json_encode($existingFlightBookingData, JSON_UNESCAPED_UNICODE);
            $editFlightDetail->save();
            return response()->json(['message' => 'Flight details updated successfully', 'updated_flight_details' => $existingFlightDetails]);
        }

        if ($request->edit_type == 'passenger_details') {
            $existingPassengerDetail = json_decode($editFlightDetail->passenger_details, true);
            $requestPassengerDetail = $request->input('passengers');


            if (!$existingPassengerDetail) {
                return response()->json(['error' => 'No passenger details found'], 404);
            }
            foreach ($existingPassengerDetail as $index => &$passenger) {
                if (isset($requestPassengerDetail[$index])) {
                    $updatedData = $requestPassengerDetail[$index];

                    foreach ($passenger as $key => $value) {

                        $passenger[$key] = $updatedData[$key] ?? '';
                    }
                }
            }
            unset($passenger);
            $editFlightDetail->passenger_details = json_encode($existingPassengerDetail);

            if (!empty($existingFlightBookingData['passengerDetails'])) {
                foreach ($existingFlightBookingData['passengerDetails'] as $index => &$passenger) {
                    if (isset($requestPassengerDetail[$index])) {
                        $updatedData = $requestPassengerDetail[$index];

                        foreach ($passenger as $key => $value) {

                            $passenger[$key] = $updatedData[$key] ?? '';
                        }
                    }
                }
                unset($passenger);
                $editFlightDetail->booking_details = json_encode($existingFlightBookingData, JSON_UNESCAPED_UNICODE);
            }

            $editFlightDetail->save();

            return response()->json(['success' => 'Passenger details updated successfully']);
        }
        if ($request->edit_type == 'baggage_details') {
            $existingFlightDetails = json_decode($editFlightDetail->booking_details);
            if (!$existingFlightDetails) {
                return response()->json(['error' => 'Unable to update bag details. Please try again!.'], 404);
            }

            if (!isset($existingFlightDetails->flightDetails->additionalDetails)) {
                $existingFlightDetails->flightDetails->additionalDetails = new \stdClass();
            }

            if (!isset($existingFlightDetails->flightDetails->additionalDetails->addBags)) {
                $existingFlightDetails->flightDetails->additionalDetails->addBags = new \stdClass();
            }

            if (!isset($existingFlightDetails->flightDetails->additionalDetails->addBags->selectedBagDetails)) {
                $existingFlightDetails->flightDetails->additionalDetails->addBags->selectedBagDetails = [];
            }

            $submittedBaggage = $request->baggageDetails ?? [];
            $existingBags = $existingFlightDetails->flightDetails->additionalDetails->addBags->selectedBagDetails;
            foreach ($submittedBaggage as $bagData) {
                $incomingSegmentId = $bagData['segmentId'] ?? $bagData['segementId'] ?? '';
                $incomingTravelerId = (int)($bagData['travelerId'] ?? 0);
                foreach ($existingBags as &$existingBag) {
                    if (
                        ($existingBag->segmentId ?? '') == $incomingSegmentId &&
                        (int)($existingBag->travelerId ?? 0) == $incomingTravelerId
                    ) {
                        $test[] = [
                            'segmentId' => $existingBag->segmentId,
                            'travelerid' => $existingBag->travelerId
                        ];
                        $existingBag->bag->quantity = (int)($bagData['bag']['quantity'] ?? $existingBag->bag->quantity);
                        $existingBag->bag->price->amount = $bagData['bag']['price']['amount'] ?? $existingBag->bag->price->amount;
                        $existingBag->bag->price->currencyCode = $bagData['bag']['price']['currencyCode'] ?? $existingBag->bag->price->currencyCode;
                    }
                }
            }

            $existingFlightDetails->flightDetails->additionalDetails->addBags->selectedBagDetails = $existingBags;
            // Save
            $editFlightDetail->booking_details = json_encode($existingFlightDetails, JSON_UNESCAPED_UNICODE);
            $editFlightDetail->save();

            return response()->json(['success' => 'Baggage details updated successfully']);
        }


        if ($request->edit_type === 'seat_details') {

            $submittedSeatDetails = $request->input('seatDetails');
            $existingFlightData = json_decode($editFlightDetail->booking_details ?? '{}');
            if (!$existingFlightData) {
                return response()->json(['error' => 'Unable to update seat details. Please try again!.'], 404);
            }

            $existingFlightDetails =  $existingFlightData->flightDetails ?? '{}';

            $originalSeatWrapper = $existingFlightDetails->seatDetails ?? (object)[];
            $originalSeats = $originalSeatWrapper->seatDetails ?? [];

            foreach ($originalSeats as $index => $seatEntry) {

                if (is_array($seatEntry) && isset($seatEntry[0])) {
                    $originalSeat = is_array($seatEntry[0]) ? (object) $seatEntry[0] : $seatEntry[0];
                    $originalSeats[$index][0] = $originalSeat;
                } elseif (is_object($seatEntry)) {
                    $originalSeat = $seatEntry;
                    $originalSeats[$index] = $originalSeat;
                } else {
                    continue;
                }


                if (!isset($submittedSeatDetails[$index])) {
                    continue;
                }

                $newData = $submittedSeatDetails[$index];


                $originalSeat->ticket_details = isset($originalSeat->ticket_details) && is_object($originalSeat->ticket_details)
                    ? $originalSeat->ticket_details
                    : (object)[];

                $originalSeat->price_details = isset($originalSeat->price_details) && is_object($originalSeat->price_details)
                    ? $originalSeat->price_details
                    : (object)[];


                if (!empty($newData['ticket_details']['seat_number'])) {
                    $originalSeat->ticket_details->seat_number = $newData['ticket_details']['seat_number'];
                }

                if (!empty($newData['ticket_details']['seat_charateristics'])) {
                    $originalSeat->ticket_details->seat_charateristics = $newData['ticket_details']['seat_charateristics'];
                }

                if (isset($newData['price_details']['price'])) {
                    $originalSeat->price_details->price = $newData['price_details']['price'];
                }

                if (isset($newData['price_details']['currency'])) {
                    $originalSeat->price_details->currency = $newData['price_details']['currency'];
                }


                if (is_array($seatEntry)) {
                    $originalSeats[$index][0] = $originalSeat;
                } else {
                    $originalSeats[$index] = $originalSeat;
                }
            }


            $existingFlightDetails->seatDetails->seatDetails = $originalSeats;
            $editFlightDetail->booking_details = json_encode($existingFlightData, JSON_UNESCAPED_UNICODE);
            $editFlightDetail->save();

            return response()->json(['success' => 'Seat details updated successfully']);
        }



        if ($request->edit_type == 'payment_details') {
            $requestPaymentDetails = $request->all();
            if (empty($existingFlightBookingData['processedPrice']) || empty($existingFlightBookingData['billingDetails'])) {
                return response()->json(['error' => 'Unable to update payment details'], 404);
            }

            // $existingProcessedPricee['totalPrice'] = $requestPaymentDetails['totalPrice'] ?? '';
            $existingFlightBookingData['processedPrice']['vatPercentage'] = $requestPaymentDetails['vatPercentage'] ?? '';
            $existingFlightBookingData['processedPrice']['vat'] = $requestPaymentDetails['vat'] ?? '';
            $existingFlightBookingData['processedPrice']['totalTaxAmount'] = $requestPaymentDetails['totalTaxAmount'] ?? '';
            $existingFlightBookingData['processedPrice']['chargeableSeatPrice'] = $requestPaymentDetails['chargeableSeatPrice'] ?? '';
            $existingFlightBookingData['processedPrice']['markup'] = $requestPaymentDetails['markup'] ?? '';
            $existingFlightBookingData['processedPrice']['markupType'] = $requestPaymentDetails['markupType'] ?? '';
            $existingFlightBookingData['processedPrice']['markupValue'] = $requestPaymentDetails['markupValue'] ?? '';
            $existingFlightBookingData['processedPrice']['serviceFee'] = $requestPaymentDetails['serviceFee'] ?? '';
            $existingFlightBookingData['processedPrice']['markupServiceFee'] = $requestPaymentDetails['markupServiceFee'] ?? '';
            $existingFlightBookingData['processedPrice']['grandTotal'] = $requestPaymentDetails['grandTotal'] ?? '';

            $existingFlightBookingData['processedPrice']['couponAmount'] = $requestPaymentDetails['couponAmount'] ?? 0;
            $existingFlightBookingData['processedPrice']['redeemAmount'] = $requestPaymentDetails['redeemAmount'] ?? 0;
            $existingFlightBookingData['processedPrice']['addOnAmount'] = $requestPaymentDetails['addonAmount'] ?? 0;
            $existingFlightBookingData['processedPrice']['walletAmount'] = $requestPaymentDetails['walletAmount'] ?? 0;
            $existingFlightBookingData['processedPrice']['bagAmount'] = $requestPaymentDetails['bagAmount'] ?? 0;
            $existingFlightBookingData['processedPrice']['selectedSeatsTotalPrice'] = $requestPaymentDetails['chargeableSeatPrice'] ?? 0;

            $existingFlightBookingData['processedPrice']['isCouponUsed'] = $requestPaymentDetails['couponAmount'] > 0 &&  $requestPaymentDetails['couponAmount'] != '' ? true : false;
            $existingFlightBookingData['processedPrice']['isRedeemUsed'] = $requestPaymentDetails['redeemAmount'] > 0 &&  $requestPaymentDetails['redeemAmount'] != '' ? true : false;
            $existingFlightBookingData['processedPrice']['isAddOnUsed'] = $requestPaymentDetails['addonAmount'] > 0 &&  $requestPaymentDetails['addonAmount'] != '' ? true : false;
            $existingFlightBookingData['processedPrice']['isWalletUsed'] = $requestPaymentDetails['walletAmount'] > 0 &&  $requestPaymentDetails['walletAmount'] != '' ? true : false;
            $existingFlightBookingData['processedPrice']['isBagUsed'] = $requestPaymentDetails['bagAmount'] > 0 &&  $requestPaymentDetails['bagAmount'] != '' ? true : false;
            $existingFlightBookingData['processedPrice']['isSeatUsed'] = $requestPaymentDetails['chargeableSeatPrice'] > 0 &&  $requestPaymentDetails['chargeableSeatPrice'] != '' ? true : false;


            $existingFlightBookingData['billingDetails']['address'] = $requestPaymentDetails['billing_address'] ?? '';
            $existingFlightBookingData['billingDetails']['address1'] = $requestPaymentDetails['billing_address1'] ?? '';
            $existingFlightBookingData['billingDetails']['city'] = $requestPaymentDetails['billing_city'] ?? '';
            $existingFlightBookingData['billingDetails']['state'] = $requestPaymentDetails['billing_state'] ?? '';
            $existingFlightBookingData['billingDetails']['country'] = $requestPaymentDetails['billing_country'] ?? '';
            $existingFlightBookingData['billingDetails']['zipcode'] = $requestPaymentDetails['billing_zipcode'] ?? '';
            $existingFlightBookingData['billingDetails']['state_id'] = $requestPaymentDetails['billing_state_id'] ?? '';
            $existingFlightBookingData['billingDetails']['country_id'] = $requestPaymentDetails['billing_country_id'] ?? '';
            $existingFlightBookingData['billingDetails']['customer.email'] = $requestPaymentDetails['billing_customer_email'] ?? '';
            $existingFlightBookingData['billingDetails']['customer.givenName'] = $requestPaymentDetails['billing_customer_givenName'] ?? '';
            $existingFlightBookingData['billingDetails']['customer.surname'] = $requestPaymentDetails['billing_customer_surname'] ?? '';

            $editFlightDetail->booking_details = json_encode($existingFlightBookingData, JSON_UNESCAPED_UNICODE);

            $editFlightDetail->save();
            return response()->json(['success' => 'Payment Details updated successfully']);
        }
    }


    public function updateHotelDetails(Request $request, $id)
    {
        $validated = $request->validate([
            'edit_type' => 'required',
        ]);
        // dd($request->all());

        $exitingHotelDetails = EditHotelDetail::select('id', 'booking_details')
            ->where('booking_id', $id)
            ->first();

        if (!$exitingHotelDetails) {
            return response()->json(['error' => 'Booking not found'], 404);
        }
        $existingHotelBookingData = json_decode($exitingHotelDetails->booking_details, true);
        if ($request->edit_type == 'customer_details') {
            $booking = $exitingHotelDetails;
            $booking->first_name = $request->first_name;
            $booking->last_name = $request->last_name;
            $booking->email = $request->customer_email;
            $booking->booking_date = $request->booking_date;
            $booking->booking_start_date = $request->booking_start_date;
            $booking->save();
            $existingCustomer = $existingHotelBookingData['userDetails'];
            if (!$existingCustomer) {
                return response()->json(['error' => 'Customer not found'], 404);
            }
            $existingHotelBookingData['userDetails']['first_name'] = $request->first_name ?? '';
            $existingHotelBookingData['userDetails']['firstName'] = $request->first_name ?? '';
            $existingHotelBookingData['userDetails']['last_name'] = $request->last_name ?? '';
            $existingHotelBookingData['userDetails']['lastName'] = $request->last_name ?? '';
            $existingHotelBookingData['userDetails']['email'] = $request->customer_email ?? '';
            $existingHotelBookingData['userDetails']['phoneNumber'] = $request->phoneNumber ?? '';
            $exitingHotelDetails->booking_details = json_encode($existingHotelBookingData, JSON_UNESCAPED_UNICODE);
            $exitingHotelDetails->save();
            return response()->json(['success' => 'Customer details updated successfully']);
        }

        if ($request->edit_type == 'hotel_details') {
            $existingHotelBookingData['hotelDetails']['hotelDetails']['DisplayName'] = $request->hotel_name;
            $existingHotelBookingData['hotelDetails']['hotelDetails']['Address'] = $request->Address;
            $existingHotelBookingData['searchDetails']['occupancies'][0]['children'] = (int) $request->children;
            $existingHotelBookingData['searchDetails']['occupancies'][0]['adults'] = (int) $request->adult;
            $existingHotelBookingData['searchDetails']['checkInDate'] = $request->check_in;
            $existingHotelBookingData['searchDetails']['stay']['checkIn'] = $request->check_in;
            $existingHotelBookingData['searchDetails']['checkOutDate'] = $request->check_out;
            $existingHotelBookingData['searchDetails']['stay']['checkOut'] = $request->check_out;
            $existingHotelBookingData['searchDetails']['city'] = $request->city;
            $existingHotelBookingData['searchDetails']['nationality'] = $request->country;


            $exitingHotelDetails->booking_details = json_encode($existingHotelBookingData, JSON_UNESCAPED_UNICODE);
            $exitingHotelDetails->save();
            return response()->json(['success' => 'Hotel details updated successfully']);
        }

        if ($request->edit_type == 'payment_details') {

            $existingProcessedPrice = $existingHotelBookingData['processedPrice'];
            $existingBillingDetails = $existingHotelBookingData['billingDetails'];
            if (!$existingProcessedPrice || !$existingBillingDetails) {
                return response()->json(['error' => 'No details found'], 404);
            }

            $requestPaymentDetails = $request->all();



            $existingHotelBookingData['processedPrice']['totalPrice'] = $requestPaymentDetails['totalPrice'] ?? '';
            $existingHotelBookingData['processedPrice']['vatPercentage'] = $requestPaymentDetails['vatPercentage'] ?? '';
            $existingHotelBookingData['processedPrice']['vat'] = $requestPaymentDetails['vat'] ?? '';
            $existingHotelBookingData['processedPrice']['totalTaxAmount'] = $requestPaymentDetails['totalTaxAmount'] ?? '';
            $existingHotelBookingData['processedPrice']['chargeableSeatPrice'] = $requestPaymentDetails['chargeableSeatPrice'] ?? '';
            $existingHotelBookingData['processedPrice']['markup'] = $requestPaymentDetails['markup'] ?? '';
            $existingHotelBookingData['processedPrice']['markupType'] = $requestPaymentDetails['markupType'] ?? '';
            $existingHotelBookingData['processedPrice']['markupValue'] = $requestPaymentDetails['markupValue'] ?? '';
            $existingHotelBookingData['processedPrice']['serviceFee'] = $requestPaymentDetails['serviceFee'] ?? '';
            $existingHotelBookingData['processedPrice']['markupServiceFee'] = $requestPaymentDetails['markupServiceFee'] ?? '';
            $existingHotelBookingData['processedPrice']['grandTotal'] = $requestPaymentDetails['grandTotal'] ?? '';
            $existingHotelBookingData['processedPrice']['couponAmount'] = $requestPaymentDetails['couponAmount'] ?? 0;
            $existingHotelBookingData['processedPrice']['redeemAmount'] = $requestPaymentDetails['redeemAmount'] ?? 0;
            $existingHotelBookingData['processedPrice']['addOnAmount'] = $requestPaymentDetails['addonAmount'] ?? 0;
            $existingHotelBookingData['processedPrice']['walletAmount'] = $requestPaymentDetails['walletAmount'] ?? 0;
            $existingHotelBookingData['processedPrice']['isCouponUsed'] = $requestPaymentDetails['couponAmount'] > 0 &&  $requestPaymentDetails['couponAmount'] != '' ? true : false;
            $existingHotelBookingData['processedPrice']['isRedeemUsed'] = $requestPaymentDetails['redeemAmount'] > 0 &&  $requestPaymentDetails['redeemAmount'] != '' ? true : false;
            $existingHotelBookingData['processedPrice']['isAddOnUsed'] = $requestPaymentDetails['addonAmount'] > 0 &&  $requestPaymentDetails['addonAmount'] != '' ? true : false;
            $existingHotelBookingData['processedPrice']['isWalletUsed'] = $requestPaymentDetails['walletAmount'] > 0 &&  $requestPaymentDetails['walletAmount'] != '' ? true : false;




            $existingHotelBookingData['billingDetails']['address'] = $requestPaymentDetails['billing_address'] ?? '';
            $existingHotelBookingData['billingDetails']['address1'] = $requestPaymentDetails['billing_address1'] ?? '';
            $existingHotelBookingData['billingDetails']['city'] = $requestPaymentDetails['billing_city'] ?? '';
            $existingHotelBookingData['billingDetails']['state'] = $requestPaymentDetails['billing_state'] ?? '';
            $existingHotelBookingData['billingDetails']['country'] = $requestPaymentDetails['billing_country'] ?? '';
            $existingHotelBookingData['billingDetails']['zipcode'] = $requestPaymentDetails['billing_zipcode'] ?? '';
            $existingHotelBookingData['billingDetails']['state_id'] = $requestPaymentDetails['billing_state_id'] ?? '';
            $existingHotelBookingData['billingDetails']['country_id'] = $requestPaymentDetails['billing_country_id'] ?? '';
            $existingHotelBookingData['billingDetails']['customer.email'] = $requestPaymentDetails['billing_customer_email'] ?? '';
            $existingHotelBookingData['billingDetails']['customer.givenName'] = $requestPaymentDetails['billing_customer_givenName'] ?? '';
            $existingHotelBookingData['billingDetails']['customer.surname'] = $requestPaymentDetails['billing_customer_surname'] ?? '';
            $exitingHotelDetails->booking_details = json_encode($existingHotelBookingData, JSON_UNESCAPED_UNICODE);
            $exitingHotelDetails->save();
            return response()->json(['success' => 'Payment Details updated successfully']);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function test($id, Request $request)
    {
        $bookingDetails = Bookings::where('booking_ref', $id)->first();
        $this->sendBookingEmail2($bookingDetails);
    }




    public function updateBookingStatus(Request $request)
    {

        $validated = $request->validate([
            'booking_id' => 'required|exists:bookings,id',
            'status' => 'required|string|in:confirmed,supplier_failed,payment_failed',
            'description' => 'nullable|string|max:255',
        ]);


        $booking = Bookings::find($request->booking_id);
        $booking->booking_status_description = $request->description ?? 'Nill';
        if ($request->status == BookingStatus::Confirmed->value) {
            $booking->booking_status = $request->status;
            $booking->booking_sub_status = BookingStatus::Supplier_Success->value;
        } else if ($request->status == BookingStatus::Supplier_Failed->value) {
            $booking->booking_status = BookingStatus::Failed->value;
            $booking->booking_sub_status = BookingStatus::Supplier_Failed->value;
        } else if ($request->status == PaymentStatus::Payment_Failed->value) {
            $booking->booking_status = BookingStatus::Failed->value;
            $booking->booking_sub_status = BookingStatus::Supplier_Success_Payment_Failed->value;
        } else {

            $booking->booking_status = $request->status;
        }
        $booking->save();


        $booking_log = BookingStatusLog::create([
            'booking_id' => $request->booking_id,
            'booking_status_from' => $booking->booking_status ==  BookingStatus::Failed->value ? ($booking->booking_sub_status == 'Supplier success and Payment failed' ? 'Payment_Failed' :  BookingStatus::Supplier_Failed->value) : $booking->booking_status,
            'booking_status_to' => $request->status,
            'booking_status_description' => $request->description ?? 'Nill',
            'modified_by' => Auth::id(),
        ]);

        return response()->json(['message' => 'Booking status updated successfully!']);
    }


    public function downloadVoucher($id, $mode = "download")
    {
        $header['title'] = "View Booking";
        $header['heading'] = "View Booking";

        $filter = array(
            'id' => $id
        );

        $bookingListData = Bookings::getBookings($filter);
        $bookingDataCount = Bookings::count();
        $bookingData = $bookingListData['data'];

        $supplierDataList = Suppliers::get()->toArray();
        $getServiceType = ServiceType::get()->toArray();
        $getAgency = Agency::get()->toArray();
        $activityLog['request'] = request()->input();
        $activityLog['request_url'] = request()->url();
        $activityLog['response'] = $bookingData;

        if (!empty($bookingData)) {
            if ($mode == "download") {
                if ($bookingData->booking_type == "Hotel") {

                    $supplierResponse = json_decode($bookingData->service_provider_response, true);


                    $supplierName = 'N/A';
                    $vatNumber = 'N/A';
                    $bookingReference = 'N/A';

                    if (isset($supplierResponse['booking']['hotel']['supplier'])) {
                        $supplier = $supplierResponse['booking']['hotel']['supplier'];
                        $supplierName = isset($supplier['name']) ? $supplier['name'] : 'N/A';
                        $vatNumber = isset($supplier['vatNumber']) ? $supplier['vatNumber'] : 'N/A';
                    }

                    if (isset($supplierResponse['booking']['reference'])) {
                        $bookingReference = $supplierResponse['booking']['reference'];
                    }

                    $bookingNotes = 'Payable through ' . $supplierName .
                        ', acting as agent for the service operating company, details of which can be provided upon request. VAT: ' .
                        $vatNumber . ' Reference: ' . $bookingReference;

                    $pdf = FacadePdf::loadView('admin/booking/download_voucher_hotel', [
                        'header' => $header,
                        'bookingDetail' => $bookingData,
                        'bookingNotes' => $bookingNotes,
                    ])->setPaper('a4', 'portrait')
                        ->setOption('dpi', 150)
                        ->setOption('isHtml5ParserEnabled', true)
                        ->setOption('isPhpEnabled', true)
                        ->setOption('zoom', 0.8);

                    return $pdf->download('hotel_booking_voucher.pdf');
                } else {

                    $pdf = FacadePdf::loadView('admin/booking/download', [
                        'header' => $header,
                        'bookingDetail' => $bookingData,
                    ])->setPaper('a4', 'portrait')
                        ->setOption('dpi', 150)
                        ->setOption('isHtml5ParserEnabled', true)
                        ->setOption('isPhpEnabled', true)
                        ->setOption('zoom', 0.8);

                    return $pdf->download('booking_voucher.pdf');
                }
            } else {

                return view('admin/booking/view')->with([
                    'header' => $header,
                    'bookingDetail' => $bookingData,
                ]);
            }
        } else {

            return redirect()->route('booking.index')->with('error', 'Booking not found.');
        }
    }





    public function downloadInvoiceOld($id)
    {
        $header['title'] = "View Booking";
        $header['heading'] = "View Booking";

        $filter = [
            'id' => $id
        ];

        $bookingListData = Bookings::getBookings($filter);
        $bookingData = $bookingListData['data'];

        if (!empty($bookingData)) {
            if ($bookingData->booking_type == "Hotel") {
                $supplierResponse = json_decode($bookingData->service_provider_response, true);


                if (isset($supplierResponse['booking']['hotel']['supplier'])) {
                    $supplier = $supplierResponse['booking']['hotel']['supplier'];
                    $supplierName = isset($supplier['name']) ? $supplier['name'] : 'N/A';
                    $vatNumber = isset($supplier['vatNumber']) ? $supplier['vatNumber'] : 'N/A';
                } else {
                    $supplierName = 'N/A';
                    $vatNumber = 'N/A';
                }


                $bookingReference = isset($supplierResponse['booking']['reference']) ? $supplierResponse['booking']['reference'] : 'N/A';


                $bookingNotes = 'Payable through ' . $supplierName .
                    ', acting as agent for the service operating company, details of which can be provided upon request. VAT: ' .
                    $vatNumber . ' Reference: ' . $bookingReference;

                $pdf = FacadePdf::loadView('admin/booking/download_hotel_invoice', [
                    'header' => $header,
                    'bookingDetail' => $bookingData,
                    'bookingNotes' => $bookingNotes
                ])->setPaper('a4', 'portrait')
                    ->setOption('dpi', 150)
                    ->setOption('isHtml5ParserEnabled', true)
                    ->setOption('isPhpEnabled', true)
                    ->setOption('zoom', 0.8)
                    ->setOption('enable_remote', true);


                return $pdf->download('Invoice_' . $id . '.pdf');
            } else {
                $pdf = FacadePdf::loadView('admin/booking/download', [
                    'header' => $header,
                    'bookingDetail' => $bookingData
                ])->setPaper('a4', 'portrait')
                    ->setOption('dpi', 150)
                    ->setOption('isHtml5ParserEnabled', true)
                    ->setOption('isPhpEnabled', true)
                    ->setOption('zoom', 0.8)
                    ->setOption('enable_remote', true);

                return $pdf->download('Invoice_' . $id . '.pdf');
            }
        } else {
            return redirect()->route('booking.index')->with('error', 'Booking not found.');
        }
    }



    public function showFlightTicket($id, $locale = Locale::English->value)
    {
        $header['title'] = "View Booking";
        $header['heading'] = "View Booking";

        $filter = array(
            'id' => $id
        );

        $mode = 'download';

        $bookingListData = Bookings::getBookings($filter);
        $bookingData = $bookingListData['data'];

        $activityLog['request'] =  request()->input();
        $activityLog['request_url'] =  request()->url();
        $activityLog['response'] =  $bookingData;
        $additionalBookingDetails = BookingAdditionalDetail::where('booking_id', $id)->first();
        $invoiceSettings = InvoiceSetting::first();
        view()->share('invoiceSettings', $invoiceSettings);
        $pageDetails = null;
        if (!empty($bookingData)) {
            if ($mode == "download") {

                $editedFlightDetails = EditFlightDetail::where('booking_id', $id)->get();
                $pageId = Page::where('page_code', 'important-information-hotel')->orWhere('slug_url', 'flight-ticket-useful-info')->select('id')->first();
                if ($pageId) {
                    $pageDetails = PageI18ns::where('page_id', $pageId->id)->where('language_code', $locale)->first();
                }

                $bookingDetails = json_decode($editedFlightDetails[0], true);

                $bookingDetails = [
                    'booking_details' => [
                        'booking_details' => json_decode($bookingDetails['booking_details'], true)
                    ]
                ];

                $tranlatedFlightDetails = TranslateBookingDetails::translateFlightBookingDetails($bookingDetails, $locale);
                $editedFlightDetails[0]->booking_details = json_encode($tranlatedFlightDetails['booking_details']['booking_details']);
                // dd(json_decode($editedFlightDetails[0]->booking_details , true));
                if ($locale == Locale::English->value) {
                    return view('admin/booking/download_flight_ticket')->with(['header' => $header, 'bookingDetail' => $bookingData, 'editedFlightDetails' => $editedFlightDetails, 'additionalBookingDetails' => $additionalBookingDetails, 'pageDetails' => $pageDetails]);
                }
                return view('admin/booking/download_flight_ticket_ar')->with(['header' => $header, 'bookingDetail' => $bookingData, 'editedFlightDetails' => $editedFlightDetails, 'additionalBookingDetails' => $additionalBookingDetails, 'pageDetails' => $pageDetails]);
            } else {
                return view('admin/booking/view')->with(['header' => $header, 'bookingDetail' => $bookingData]);
            }
        } else {
            return redirect()->route('booking.index')->with('error', 'Something went wrong, please try again later.');
        }
    }


    public function showFlightTicketTest($id, $locale)
    {
        $header['title'] = "View Booking";
        $header['heading'] = "View Booking";

        $filter = array(
            'id' => $id
        );

        $mode = 'download';

        $bookingListData = Bookings::getBookings($filter);
        $bookingData = $bookingListData['data'];

        $activityLog['request'] =  request()->input();
        $activityLog['request_url'] =  request()->url();
        $activityLog['response'] =  $bookingData;
        $additionalBookingDetails = BookingAdditionalDetail::where('booking_id', $id)->first();
        $pageDetails = null;
        if (!empty($bookingData)) {
            if ($mode == "download") {

                $editedFlightDetails = EditFlightDetail::where('booking_id', $id)->get();
                $pageId = Page::where('page_code', 'important-information-hotel')->orWhere('slug_url', 'important-information-hotel')->select('id')->first();
                if ($pageId) {
                    $pageDetails = PageI18ns::where('page_id', $pageId->id)->where('language_code', $locale)->first();
                }

                $bookingDetails = json_decode($editedFlightDetails[0], true);
                $bookingDetails = [
                    'booking_details' => [
                        'booking_details' => json_decode($bookingDetails['booking_details'], true)
                    ]
                ];
                $tranlatedFlightDetails = TranslateBookingDetails::translateFlightBookingDetails($bookingDetails, $locale);
                $editedFlightDetails[0]->booking_details = json_encode($tranlatedFlightDetails['booking_details']['booking_details']);
                // dd(json_decode($editedFlightDetails[0]->booking_details , true));
                if ($locale == Locale::English->value) {
                    return view('admin/booking/download_flight_ticket')->with(['header' => $header, 'bookingDetail' => $bookingData, 'editedFlightDetails' => $editedFlightDetails, 'additionalBookingDetails' => $additionalBookingDetails, 'pageDetails' => $pageDetails]);
                }
                return view('admin/booking/download_flight_ticket_ar')->with(['header' => $header, 'bookingDetail' => $bookingData, 'editedFlightDetails' => $editedFlightDetails, 'additionalBookingDetails' => $additionalBookingDetails, 'pageDetails' => $pageDetails]);
            } else {
                return view('admin/booking/view')->with(['header' => $header, 'bookingDetail' => $bookingData]);
            }
        } else {
            return redirect()->route('booking.index')->with('error', 'Something went wrong, please try again later.');
        }
    }





    public function downloadFlightTicket($id, $locale = Locale::English->value)
    {
        $baseUrl = url('/');
        $filename = "ticket_pdf/" . rand() . ".pdf";
        $isApi = request()->is('api/v1/*');

        $auth = self::checkAuthenticated($isApi);

        if ($auth instanceof \Illuminate\Http\Response) {
            return $auth;
        }

        $prefix = $isApi ? 'api/v1/' : '';
        $url = $baseUrl . '/' . $prefix . 'booking/showFlightTicket/' . $id . '/' . $locale;

        $where = [
            [
                'field' => 'id',
                'condition' => '=',
                'value' => $id
            ]
        ];

        $bookingDetailsResponse = Bookings::getBooking($where);

        if ($bookingDetailsResponse['status'] == 'true') {
            $bookingDetails = $bookingDetailsResponse['data'][0];
            $filename = $bookingDetails['booking_ref'] . ".pdf";
        }

        $pdf_file_url = public_path("ticket_pdf/" . $filename);

        // Ensure the directory exists
        if (!file_exists(public_path("ticket_pdf"))) {
            mkdir(public_path("ticket_pdf"), 0755, true);
        }

        // Generate the PDF with wkhtmltopdf
        // $cmd = escapeshellcmd("wkhtmltopdf --enable-local-file-access $url $pdf_file_url");
        $cmd =  "wkhtmltopdf $url $pdf_file_url 2>&1";
        $output = [];
        exec($cmd, $output, $return_var);
        // echo "JJ";
        // exit();
        if ($return_var !== 0) {
            // Handle error
            // dd($output);
        }

        // Output the file
        if (file_exists($pdf_file_url)) {
            header("Content-type: application/pdf");
            header("Content-Disposition: attachement; filename=" . $filename);
            readfile($pdf_file_url);
            exit;
        } else {
            abort(404, 'PDF not generated');
        }
    }


    public function bookingStatusLog($id)
    {
        $header['title'] = "Booking - Booking Status Log";
        $header['heading'] = "Booking - Booking Status Log";

        return view('admin/booking/booking_status_log', ['booking_id' => $id, 'header' => $header]);
    }

    public function fetchBookingStatusLog(Request $request, $id)
    {
        if ($request->ajax()) {
            $booking = Bookings::find($id);

            if (!$booking) {
                return response()->json(['error' => 'Booking not found'], 404);
            }

            $bookingLogs = BookingStatusLog::with('user')->where('booking_id', $id)->orderBy('created_at', 'desc')->get();


            return DataTables::of($bookingLogs)
                ->editColumn('booking_id', function ($log) use ($booking) {
                    $url = route('booking.edit', $booking->id);
                    $ref = $booking->booking_ref;
                    return '<a href="' . $url . '">' . $ref . '</a>';
                })
                ->editColumn('modified_by', function ($log) {
                    $userName = $log->user ? e($log->user->name) : 'N/A';
                    return '<a href="/user" style="color: black;">' . $userName . '</a>';
                })
                ->editColumn('booking_status', function ($log) {
                    $from = ucwords($log->booking_status_from) ?? 'N/A';
                    $to = ucwords($log->booking_status_to) ?? 'N/A';

                    return '<span style="color: #444;">' . e($from) . '</span> &rarr; <span style="color: #000; font-weight: bold;">' . e($to) . '</span>';
                })


                ->editColumn('created_at', function ($log) {
                    return $log->created_at ? $log->created_at->format('d-M-Y, g:i A') : '';
                })
                ->rawColumns(['booking_id', 'created_at', 'modified_by', 'booking_status'])
                ->make(true);
        }
    }
}
