<?php


/**
 * @package     Dashboard
 * @subpackage   Best Offers
 * @Author      Amar Technolabs Pvt. ltd(info@amarinfotech.com)
 * @Copyright(C) 2023 [Travel Portal].
 * @Version 1.0.0
 * module of the  Dashboard.
 */

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\URL;
use Intervention\Image\ImageManagerStatic as Image;
use Illuminate\Validation\Rule;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Facades\Excel;
use App\Models\Setting;
use App\Models\BestOffer;
use App\Traits\EmailService;
use Carbon\Carbon;

class BestOfferController extends Controller
{
    use EmailService;
    /**
     * Display a listing of the Best Offers.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $header['title'] = "Best Offers";
        $header['heading'] = "Best Offers";
        $queryStringConcat = '?';
        if (isset($_GET['per_page'])) {
            $queryStringConcat .= ($queryStringConcat == '') ? '?per_page=' . $_GET['per_page'] : '&per_page=' . $_GET['per_page'];
        }
        if (isset($_GET['page'])) {
            $queryStringConcat .= ($queryStringConcat == '') ? '?page=' . $_GET['page'] : '&page=' . $_GET['page'];
        }

        $filter = array(
            'per_page' => (request()->input('per_page') != NULL) ? request()->input('per_page') : Setting::where('config_key', 'general|setting|pagePerAdminRecords')->get('value')[0]['value'],
            'order_by' => (request()->input('order_by') != NULL) ? request()->input('order_by') : 'created_at',
            'sorting' => (request()->input('sorting') != NULL) ? request()->input('sorting') : 'desc',
            'status' => (request()->input('status') != NULL) ? request()->input('status') : '',
        );
        if (request()->input('offer_title') != NULL) {
            $offerTitle = request()->input('offer_title');
            $filter['where'][] = [
                DB::raw("offer_title"),
                'LIKE',
                '%' . $offerTitle . '%'
            ];
        }
        if (request()->input('status') != NULL) {
            $filter['where'][] = ['status', '=', request()->input('status')];
        }
        $bestOffersDataList = BestOffer::getBestOffers($filter);
        $bestOffersData = $bestOffersDataList['data'];
        if ($bestOffersData['status'] == 1) {
            return view('admin/best-offers/index')->with(['header' => $header, 'bestOffersData' => $bestOffersData, 'queryStringConcat' => $queryStringConcat, 'appliedFilter' => $filter,  'i' => (request()->input('page', 1) - 1) * $filter['per_page']]);
        } else {
            return view('admin/best-offers/index')->with(['header' => $header, 'bestOffersData' => $bestOffersData, 'queryStringConcat' => $queryStringConcat, 'appliedFilter' => $filter, 'i' => (request()->input('page', 1) - 1) * $filter['per_page']]);
        }
    }

    /**
     * Show the form for creating a new best offer
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {
        if (!hasPermission('CUSTOMERS_LIST', 'create')) {
            return view('admin/401');
        }
        $bestOfferId = $request->id;
        $header['title'] = 'Best Offers - Add';

        return view('admin/best-offers/add')->with(['header' => $header]);
    }

    /**
     * Store a newly created best offers in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $requestData = $request->all();
        $response = BestOffer::createBestOffer($requestData);
        if (!empty($response['data'])) {
            return redirect()->route('best-offers.index', $response)->with('success', $response['message']);
        } else {
            return redirect()->back()->with('error', $response['message']);
        }
    }

    /**
     * Display the specified best offer.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        if (!hasPermission('TRAVELLER_LIST', 'read')) {
            return view('admin/401');
        }
        $header['title'] = 'Best Offers - View';
        $header['heading'] = 'Best Offers - View';
        $filter = array(
            'id' => $id
        );
        $response = BestOffer::getBestOffers($filter);

        $bestOfferDetails = $response['data'];
        if ($response['status'] == 1 && !empty($response['data'])) {
            return view('admin/best-offers/view')->with(['header' => $header, 'bestOfferDetails' => $bestOfferDetails]);
        } else {
            return redirect()->route('best-offers.index')->with('error', $response['message']);
        }
    }

    /**
     * Show the form for editing the specified best offer.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        if (!hasPermission('CUSTOMERS_LIST', 'update')) {
            return view('admin/401');
        }
        $header['title'] = 'Best Offer - Edit';
        $header['heading'] = 'Best Offer - Edit';
        $header['method'] = 'Edit';

        $filter = array(
            'id' => $id
        );
        $response = BestOffer::getBestOffers($filter);
        $bestOfferDetail = $response['data'];
        if ($response['status'] == 1 && !empty($response['data'])) {
            return view('admin/best-offers/update')->with(['header' => $header, 'bestOfferDetail' => $bestOfferDetail]);
        } else {
            return redirect()->route('best-offers.index')->with('error', $response['message']);
        }
    }

    /**
     * Update the specified best offer in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $url = $request->redirects_to;
        $requestData = $request->all();

        $rules = [];
        $customMessages = [];

        $niceNames = array();

        $this->validate($request, $rules, $customMessages, $niceNames);

        $response = BestOffer::updateBestOffer($requestData);

        if (!empty($response['data'])) {
            return redirect()->route('best-offers.index', compact('id'))->with('success', $response['message']);
        } else {
            return redirect()->to($url)->with('error', $response['message']);
        }
    }

    /**
     * Remove the specified best offer from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function deleteBestOffer($bestOfferID)
    {
        $url = URL::previous();
        $response = BestOffer::deleteBestOffer($bestOfferID);
        $message = $response['message'] . '</br>';

        if ($response['status'] == 1) {
            return redirect()->to($url)->with('success', $message);
        } else {
            return redirect()->to($url)->with('error', $response['message']);
        }
    }
}
