<?php

namespace App\Http\Controllers\API\V1;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Cache;

class ImageProxyController extends Controller
{
    public function hotelImage1($any)
    {
        $originalUrl = 'https://content.hsp.gimmonix.com/' . $any;
        return redirect()->away($originalUrl);
    }

    // Handle the image proxy request
    public function hotelImage($any)
    {
        ob_clean();
        ob_start();
        if (!preg_match('/^images\/.+\.(jpe?g|png|webp)$/i', $any)) {
            abort(403, 'Invalid image path');
        }

        $originalUrl = 'https://content.hsp.gimmonix.com/' . $any;

        $response = Http::withHeaders([
            'User-Agent' => 'Mozilla/5.0',
        ])->timeout(10)->get($originalUrl);

        if (!$response->successful()) {
            abort(404, 'Image not found: ' . $response->status());
        }

        return response($response->body(), 200)
            ->header('Content-Type', $response->header('Content-Type', 'image/jpeg'))
            ->header('Cache-Control', 'no-store, no-cache, must-revalidate, max-age=0')
            ->header('Pragma', 'no-cache');
    }

    // public function hotelImageWithCache($any)
    // {

    //     if (!preg_match('/^images\/.+\.(jpe?g|png|webp)$/i', $any)) {
    //         abort(403, 'Invalid image path');
    //     }

    //     $originalUrl = 'https://content.hsp.gimmonix.com/' . $any;

    //     $cacheKey = 'gimmonix_image_' . md5($originalUrl);
    //     $imageData = Cache::remember($cacheKey, now()->addHours(2), function () use ($originalUrl) {
    //         $response = Http::timeout(5)->get($originalUrl);
    //         if ($response->successful()) {
    //             return [
    //                 'body' => $response->body(),
    //                 'content_type' => $response->header('Content-Type')
    //             ];
    //         }
    //         return null;
    //     });

    //     if (!$imageData) {
    //         abort(404, 'Image not found');
    //     }

    //     return response($imageData['body'], 200)
    //         ->header('Content-Type', $imageData['content_type']);
    // }
}
