<?php

namespace App\Exports;

use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class TranslateExport implements FromCollection, WithHeadings, WithStyles
{
    protected $englishTranslationsdata;
    protected $arabicTranslationsdata;

    public function __construct($id)
    {
        $jsonContent = fetchTranslateJson($id);

        $englishJsonContent = $jsonContent['englishJsonContent'] ?? '{}';
        $arabicJsonContent = $jsonContent['arabicJsonContent'] ?? '{}';

        $this->englishTranslationsdata = json_decode($englishJsonContent, true);
        $this->arabicTranslationsdata = json_decode($arabicJsonContent, true);
    }

    /**
     * Return data for export
     */
    public function collection()
    {
        $data = [];

        foreach ($this->englishTranslationsdata as $key => $englishValue) {
            $arabicValue = $this->arabicTranslationsdata[$key] ?? '';
            $data[] = [
                $key,
                $englishValue,
                $arabicValue,
            ];
        }

        return collect($data);
    }

    /**
     * Excel Headings
     */
    public function headings(): array
    {
        return [
            'Key',
            'Value English',
            'Value Arabic',
        ];
    }

    /**
     * Apply bold styling to headings
     */
    public function styles(Worksheet $sheet)
    {
        return [
            1 => ['font' => ['bold' => true]], 
        ];
    }
}
