<?php

namespace App\Exports;

use App\Models\HotelFacilityAr;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;

class HotelFacilityExport implements FromCollection, WithHeadings, WithMapping
{
    /**
     * @return \Illuminate\Support\Collection
     */
    public function collection()
    {
        return HotelFacilityAr::get(); 
    }

    /**
     * Add headings to the Excel sheet
     */
    public function headings(): array
    {
        return [
            'Facility Name (EN)',
            'Facility Name (AR)',
            'Created At',
        ];
    }

    /**
     * Map each row of data
     */
    public function map($facility): array
    {
        return [
            $facility->facility_name_en,
            $facility->facility_name_ar,
            $facility->created_at->format('Y-m-d H:i:s'), 
        ];
    }
}
