<?php

namespace App\Exceptions;

use Illuminate\Foundation\Exceptions\Handler as ExceptionHandler;
use Throwable;
use Sentry\Laravel\Integration;
use Illuminate\Auth\AuthenticationException;
use Illuminate\Http\Exceptions\ThrottleRequestsException;

class Handler extends ExceptionHandler
{
    /**
     * A list of the exception types that are not reported.
     *
     * @var array<int, class-string<Throwable>>
     */
    protected $dontReport = [
        //
    ];

    /**
     * A list of the inputs that are never flashed for validation exceptions.
     *
     * @var array<int, string>
     */
    protected $dontFlash = [
        'current_password',
        'password',
        'password_confirmation',
    ];

    /**
     * Register the exception handling callbacks for the application.
     *
     * @return void
     */

    public function register()
    {
        $this->reportable(function (Throwable $e) {
            // Integration::captureUnhandledException($e);
        });
    }



    public function render($request, Throwable $exception)
    {
        if ($exception instanceof ThrottleRequestsException) {

            // Flash message
            session()->flash('error', 'Too many attempts. Try again after 2 minute.');

            return redirect()->back()->withInput();
        }

        return parent::render($request, $exception);
    }

    protected function unauthenticated($request, AuthenticationException $exception)
    {
        //        var_dump($request->route()->action['middleware'][0]);die;
        //if (!$request->expectsJson()) {
        if ($request->route()->action['middleware'][0] == 'api' || $request->route()->action['middleware'][0] == 'appuser-api') {
            return response()->json(['status' => false, 'message' => 'Unauthenticated.'], 401);
        }

        return redirect()->guest(route('admin.login'));
    }
}
