<?php

namespace App\Console\Commands;

use App\Models\CronJob;
use App\Models\TrendingFlight;
use App\Models\TrendingHotel;
use App\Traits\ClearsHomePageCache;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;

class TrendingSearch extends Command
{
    use ClearsHomePageCache;
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'update-trending-search';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Update expired trending hotel and flight search dates';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        Log::channel('trending')->info('TrendingSearch command started at ' . now());

        $today = now()->format('Y-m-d');
        $rand = rand(2, 6);
        $newToDate = now()->addDays($rand)->format('Y-m-d');

        // Update expired trending hotels
        $updatedHotels = TrendingHotel::where('from_date', '<=', $today)
            ->update([
                'from_date' => $today,
                'to_date' => $newToDate,
                'no_of_nights' => round((strtotime($newToDate) - strtotime($today)) / 86400),
            ]);

        // Update expired trending flights
        $updatedFlights = TrendingFlight::where('from_date', '<=', $today)
            ->update([
                'from_date' => $today,
                'to_date' => $newToDate
            ]);
        $this->clearHomePageCaches();

        $this->info("Updated $updatedHotels expired Trending Hotel(s).");
        $this->info("Updated $updatedFlights expired Trending Flight(s).");

        Log::channel('trending')->info('TrendingSearch command completed at ' . now());
    }
}
